<?php
defined('BASEPATH') OR exit('No direct script access allowed');


class manualEventController extends CI_Controller {
	
	public function __construct(){
	    parent::__construct();
		$this->load->model('Nzoho');
	}

	public function manualEventHandler(){

		if(isset($_POST['spid']) && ($_POST['spid'] != "") && isset($_POST['actfor']) && ($_POST['actfor'] == "getevents")){
		    $events = $this->get_speaker_events($_POST['spid'], (isset($_POST['selecteddate'])) ? $_POST['selecteddate'] : "" );
		    echo json_encode(array('status' => "success", 'message' => "", 'data' => $events));
		}elseif(isset($_POST['actfor']) && ($_POST['actfor'] == "updateEvent")){
		    $events = $this->update_event($_POST);
		    echo json_encode(array('status' => "success", 'message' => "", 'data' => $events));
		}elseif(isset($_POST['actfor']) && ($_POST['actfor'] == "updateNote")){
		    $events = $this->update_note($_POST);
		    echo json_encode(array('status' => "success", 'message' => "", 'data' => $events));
		}elseif(isset($_POST['actfor']) && ($_POST['actfor'] == "get_all_events")){
		    $events = $this->get_all_events((isset($_POST['selecteddate'])) ? $_POST['selecteddate'] : "" );
		    echo json_encode(array('status' => "success", 'message' => "", 'data' => $events));
		}elseif(isset($_POST['spid']) && ($_POST['spid'] != "") && isset($_POST['selecteddate']) && ($_POST['selecteddate'] != "") && isset($_POST['actfor']) && ($_POST['actfor'] == "conflictcheck")){
		    $events = [];
		    $events = $this->conflict_check_speaker_events($_POST['spid'], $_POST['selecteddate']);
		    // print_r($events);
		    echo json_encode(array('status' => (count($events) > 0) ? "success" : "error", 'message' => "", 'data' => $events));
		}elseif(isset($_POST['actfor']) && ($_POST['actfor'] == "saveevent")){
		    $this->save_event($_POST);
		    echo json_encode(array('status' => "success", 'message' => "Event saved successfully."));
		}elseif(isset($_POST['actfor']) && ($_POST['actfor'] == "savenote")){
		    $this->save_note($_POST);
		    echo json_encode(array('status' => "success", 'message' => "Note saved successfully."));
		}elseif(isset($_POST['event_id']) && ($_POST['event_id'] != "") && isset($_POST['actfor']) && ($_POST['actfor'] == "getnotes")){
		    $events = $this->get_manual_notes($_POST['event_id']);
		    echo json_encode(array('status' => "success", 'message' => "", 'data' => $events));
		}elseif(isset($_POST['event_id']) && ($_POST['event_id'] != "") && isset($_POST['actfor']) && ($_POST['actfor'] == "deleteevent")){
		    $this->delete_manual_events($_POST);
		    echo json_encode(array('status' => "success", 'message' => "Event deleted successfully."));
		}elseif(isset($_POST['note_id']) && ($_POST['note_id'] != "") && isset($_POST['actfor']) && ($_POST['actfor'] == "deletenote")){
		    $this->delete_note($_POST);
		    echo json_encode(array('status' => "success", 'message' => "Event deleted successfully."));
		}elseif(isset($_POST['event_id']) && ($_POST['event_id'] != "") && isset($_POST['actfor']) && ($_POST['actfor'] == "deleterecurevent")){
		    $this->delete_manual_recur_events($_POST);
		    echo json_encode(array('status' => "success", 'message' => "Event deleted successfully."));
		}

	}

	function get_speaker_events($speaker_id, $selecteddate = ""){
	    $this->db->where('speaker_id', $speaker_id);
	    if($selecteddate != ""){
	    	$this->db->like('start', date("Y-m", strtotime($selecteddate)), 'BOTH');
	    }

	    $query = $this->db->get('manual_events');
	    $result = $query->result();
	    return $result;
	}

	function get_all_events($selecteddate = ""){
	    $firstDayPrevMonth = date('Y-m-01', strtotime('-1 month', strtotime($selecteddate)));

	    // Calculate the first day of the month after the next month
	    $firstDayNextMonth = date('Y-m-01', strtotime('+2 months', strtotime($selecteddate)));
	    if($selecteddate != ""){
	    	$this->db->where('start >=', $firstDayPrevMonth);
	    	$this->db->where('start <=', $firstDayNextMonth);
	    }
	    $this->db->join('SPK_CustomModule6', 'SPK_CustomModule6.module_id = manual_events.speaker_id');
	    $result = $this->db->get('manual_events')->result();
	    return $result;
	}

	function conflict_check_speaker_events($speaker_id, $selecteddate){
	    $DB = new Dbq();
	    $sql = "SELECT * FROM manual_events WHERE speaker_id ='".$speaker_id."'"." AND start >= '".$selecteddate."'"." AND end <= '".$selecteddate."' LIMIT 1";
	    // echo $sql;
		return $DB->executeSQL($sql);
	}

	function get_manual_notes($event_id){

		$this->db->where('event_id', $event_id);
		$result = $this->db->get('manual_notes')->result();
		return $result;
	}

	function update_event($post){

		$id = $post['id'];
	    unset($post['actfor']);
	    unset($post['id']);
	    $this->db->where('id', $id);
	    $this->db->update('manual_events', $post);
	}

	function update_note($post){
	    $id = $post['id'];
	    unset($post['actfor']);
	    unset($post['id']);
	    $this->db->where('id', $id);
	    $this->db->update('manual_notes', $post);
	}

	function save_event($post){
	    $m_notes = array();
	    $m_notes['speaker_id'] = $post['speaker_id'];
	    $m_notes['notes'] = $notes = $post['notes'];
	    
	    // $post['end'] = $post['start'];
	    unset($post['actfor']);
	    unset($post['notes']);

	    $this->db->insert('manual_events', $post);
	    $event_id = $this->db->insert_id();

	    if($event_id){
	        $m_notes['event_id'] = $event_id;
	        $m_notes['rec_parent'] = (isset($post['recurring'])) ? $event_id : "";
	        if($notes != ""){
	        	$this->db->reset_query();
	        	$this->db->insert('manual_notes', $m_notes);
	        	$note_id = $this->db->insert_id();
	        }
	        // if(isset($post['recurring'])){
	        //     save_child_recurring_events($event_id, $post);
	        // }
	    }
	}

	function save_note($post){
	    
	    unset($post['actfor']);
	    $this->db->insert('manual_notes', $post);
	    return;
	}

	function save_child_recurring_events($event_id, $post){
	    // dd($post);
	    $dataArr = array();
	    $no_of_records = get_rows_number($post);
	    $post['rec_until_three_yr'] = ($post['rec_until'] == "") ? date("Y-m-d", strtotime($post['start']." +3 years")) : "";
	    for ($i=1; $i <= $no_of_records ; $i++) { 
	        $addUnit = ($post['rec_unit'] != "") ? ($post['rec_unit'] * $i) : $i;
	        $temp = array();
	        $temp = $post;
	        $temp['start'] = date("Y-m-d H:i", strtotime($post['start']." +".$addUnit." ". $post['rec_interval']));
	        $temp['end'] = date("Y-m-d H:i", strtotime($post['end']." +".$addUnit." ". $post['rec_interval']));
	        $temp['rec_parent'] = $event_id;
	        $dataArr[] = $temp;
	    }

		// $columns = array('speaker_id', 'title', 'start', 'end', 'recurring', 'rec_parent', 'rec_unit', 'rec_interval', 'rec_until', 'rec_until_three_yr' );
	    // dd($dataArr);
	    $DB = new Dbq();
	    $DB->insertBulkData($dataArr, "manual_events");
	}

	function get_rows_number($post){
	    $rec_unit = $post['rec_unit'];
	    $rec_interval = $post['rec_interval'];
	    $rec_until = $post['rec_until'];
	    $rec_unit = ($post['rec_unit'] != "") ? $post['rec_unit'] : 0;
	    $start = $post['start'];

	    if($rec_until == "")$rec_until = date("Y-m-d", strtotime($start." +3 years"));
	 
	    // print_r("rec_until = ". $rec_until);
	    $no_of_records = 0;
	    $no_of_records = datediff($start, $rec_until, $rec_interval, $rec_unit);
	    return $no_of_records;
	}

	function datediff($date1, $date2, $rec_interval, $rec_unit = 0){
	    if($date1 > $date2) return datediff($date2, $date1, $rec_interval);
	    // $first = DateTime::createFromFormat('Y-m-d', $date1);
	    // $second = DateTime::createFromFormat('Y-m-d', $date2);

	    $first = new DateTime($date1);
	    // $first = $first1->format('Y-m-d');
	    $second = new DateTime($date2);
	    // $second = $second1->format('Y-m-d');

	    // echo "-----------";
	    // echo "date1 : ";
	    // print_r($date1);
	    // echo "-----------";
	    // echo "date2 : ";
	    // print_r($date2);
	    // echo "-----------";
	    // echo "First : ";
	    // print_r($first);
	    // echo "-----------";
	    // echo "second : ";
	    // print_r($second);

	    if($rec_interval == "Days"){
	        $dateInterval = $second->diff($first);
	        $actual_no = $dateInterval->format('%a');
	    }
	    elseif($rec_interval == "Weeks"){
	        $actual_no = floor($first->diff($second)->days/7);
	    }
	    elseif($rec_interval == "Months"){
	        $dateInterval = $second->diff($first);
	        $actual_no = ((12 * $dateInterval->y) + $dateInterval->m);
	    }
	    elseif($rec_interval == "Years"){
	        $dateInterval = $second->diff($first);
	        $actual_no = $dateInterval->y;
	    }else{
	        $actual_no = 0;
	    }
	    return ($rec_unit > 0) ? ($actual_no / $rec_unit) : $actual_no;
	}

	function delete_manual_events($post){

	    $this->db->where('id', $post['event_id']);
	    $this->db->delete('manual_events');

	    $this->db->reset_query();

	    $this->db->where('event_id', $post['event_id']);
	    $this->db->delete('manual_notes');

	    if($post['recurring'] == "on" && ($post['recparent'] != "")){

	        $this->db->reset_query();

	        $this->db->where('rec_parent', $post['recparent']);
	        $this->db->delete('manual_events');

	        $this->db->reset_query();

	        $this->db->where('rec_parent', $post['recparent']);
	        $this->db->delete('manual_notes');
	    }
	    if(($post['recparent'] != "") && ($post['recparent'] != $post['event_id'])){

	        $this->db->reset_query();

	        $this->db->where('id', $post['recparent']);
	        $this->db->delete('manual_events');

	        $this->db->reset_query();

	        $this->db->where('event_id', $post['recparent']);
	        $this->db->delete('manual_notes');
	    }
	}

	function delete_note($post){
	    $this->db->where('id', $post['note_id']);
	    $this->db->delete('manual_notes');
	}

	function delete_manual_recur_events($post){
	    $DB = new Dbq();

	    $sql = "SELECT * FROM manual_events WHERE id ='".$post['event_id']."' LIMIT 1";
		$old_event = $DB->executeRowSQL($sql);
	    
	    if(isset($old_event['id']) && ($old_event['start'] != "")){
	        $stDate = $old_event['start'];

	        if($post['recurring'] == "on" && ($post['recparent'] != "")){
	            $evsql = "DELETE FROM manual_events WHERE id != '".$post['event_id']."' AND start > '".$stDate."' AND rec_parent ='".$post['recparent']."'";
	            $DB->actionRowSql($evsql);

	            $ntsql = "DELETE FROM manual_notes WHERE event_id != '".$post['event_id']."' AND rec_parent ='".$post['recparent']."'";
	            $DB->actionRowSql($ntsql);
	        }
	    }

	}

}