<?php
defined('BASEPATH') OR exit('No direct script access allowed');


class WebTabCalendarController extends CI_Controller {
	
	public function __construct(){
	    parent::__construct();
		$this->load->model('Nzoho');
	}

	public function loadCalendar(){
		$this->load->view('web_tab_calendar');
	}

	public function getAuthorInfoById(){
		$authorId = $this->input->post('authorId');
		$this->db->where('module_id', $authorId);
		$result = $this->db->get('SPK_CustomModule6')->row();
		echo json_encode($result);
	}

	public function getAllAuthors(){
		$result = $this->db->get('SPK_CustomModule6')->result();
		echo json_encode($result);
	}

	public function getDealInfoById(){
		$dealId = $this->input->post('dealId');
		$this->db->where('module_id', $dealId);
		$result = $this->db->get('SPK_Deals')->row();
		echo json_encode($result);
	}

	public function getConfirmedDealByAuthorId(){
		$authorId = $this->input->post('authorId');
		$this->db->where('Confirmed_Author_ID', $authorId);
		$result = $this->db->get('SPK_Deals')->result();
		echo json_encode($result);
	}

	public function getAllSuggestedAuthorsOfTheDeal(){
		$dealId = $this->input->post('dealId');
		$this->db->where('Suggested_Deals_ID', $dealId);
		$result = $this->db->get('SPK_LinkingModule1')->result();
		echo json_encode($result);
	}

	public function getAllSuggestedAuthorsOfTheDealWithDealInfo(){
		$dealId = $this->input->post('dealId');
		$this->db->select('SPK_Deals.*,SPK_LinkingModule1.*,SPK_LinkingModule1.Suggested_Authors as Author_Name');
		$this->db->join('SPK_Deals', 'SPK_LinkingModule1.Suggested_Deals_ID = SPK_Deals.module_id');
		$this->db->where('Suggested_Deals_ID', $dealId);
		$result = $this->db->get('SPK_LinkingModule1')->result();
		echo json_encode($result);
	}

	public function getAllDealsWhereThisSpeakerAsSuggested(){
		$authorId = $this->input->post('authorId');
		$this->db->where('Suggested_Authors_ID', $authorId);
		$result = $this->db->get('SPK_LinkingModule1')->result();
		echo json_encode($result);
	}

	public function getAllDealsWhereEventDateIsNotNull(){
		if( !empty($_POST['selecteddate']) ){
			$selecteddate = $_POST['selecteddate'];
			$firstDayPrevMonth = date('Y-m-01', strtotime('-1 month', strtotime($selecteddate)));

			// Calculate the first day of the month after the next month
			$firstDayNextMonth = date('Y-m-01', strtotime('+2 months', strtotime($selecteddate)));
			$this->db->group_start();
			$this->db->where('Event_Date >=', $firstDayPrevMonth);
			$this->db->where('Event_Date <=', $firstDayNextMonth);
			$this->db->group_end();
		}
		$this->db->where('Event_Date IS NOT NULL');
		$query = $this->db->get('SPK_Deals');

		// Execute the query and fetch the results
		$result = $query->result();
		echo json_encode($result);
	}

	public function getAllPendingDeals(){
		if( !empty($_POST['selecteddate']) ){
			$selecteddate = $_POST['selecteddate'];
			$firstDayPrevMonth = date('Y-m-01', strtotime('-1 month', strtotime($selecteddate)));

			// Calculate the first day of the month after the next month
			$firstDayNextMonth = date('Y-m-01', strtotime('+2 months', strtotime($selecteddate)));
			$this->db->group_start();
			$this->db->where('Event_Date >=', $firstDayPrevMonth);
			$this->db->where('Event_Date <=', $firstDayNextMonth);
			$this->db->group_end();
		}
		$this->db->where('Event_Date IS NOT NULL');
		$this->db->group_start();
		$this->db->where('Stage',"Offer");
		$this->db->or_where('Stage',"Confirmation");
		$this->db->group_end();
		$query = $this->db->get('SPK_Deals');
		$result = $query->result();
		echo json_encode($result);
	}

	public function getAllConfirmedDeals(){
		if( !empty($_POST['selecteddate']) ){
			$selecteddate = $_POST['selecteddate'];
			if( $_POST['view'] == "listYear" ){
				$firstDayPrevMonth = date('Y-m-01', strtotime($selecteddate));

				// Calculate the first day of the month after the next month
				$firstDayNextMonth = date('Y-m-t', strtotime($selecteddate));
				$this->db->group_start();
				$this->db->where('Event_Date >=', $firstDayPrevMonth);
				$this->db->where('Event_Date <=', $firstDayNextMonth);
				$this->db->group_end();
			}else{
				$firstDayPrevMonth = date('Y-m-01', strtotime('-1 month', strtotime($selecteddate)));

				// Calculate the first day of the month after the next month
				$firstDayNextMonth = date('Y-m-01', strtotime('+2 months', strtotime($selecteddate)));
				$this->db->group_start();
				$this->db->where('Event_Date >=', $firstDayPrevMonth);
				$this->db->where('Event_Date <=', $firstDayNextMonth);
				$this->db->group_end();
			}
		}
		$this->db->where('Event_Date IS NOT NULL');
		$this->db->group_start();
		$this->db->where('Stage',"Pre-Itinerary");
		$this->db->or_where('Stage',"Itinerary in Progress");
		$this->db->or_where('Stage',"Event Complete");
		$this->db->or_where('Stage',"Post-Event");
		$this->db->or_where('Stage',"Pre-Event");
		$this->db->group_end();
		$query = $this->db->get('SPK_Deals');
		$result = $query->result();
		echo json_encode($result);
	}
}