<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
/**/
class Nzoho extends CI_Model

{
	private $authtoken;
	private $newFormat;
	private $xml;
	private $error;
	private $code;
	private $msg;
	public function getError()
	{
		return $this->error;
	}

	public function flushError()
	{
		$this->error = '';
	}
	public function getCode()
	{
		return $this->code;
	}

	public function flushCode()
	{
		$this->code = '';
	}

	public function getMsg()
	{
		return $this->msg;
	}

	public function flushMsg()
	{
		$this->msg = '';
	}

	public function __construct($authtoken = '', $newFormat = 1)
	{
		@session_start();

		// $this->db->where('is_valid', 1);
		// $zc = $this->db->get_where('zoho_auth')->row();
		
		// if(isset($zc->api_key))
		// 	{$this->authtoken = $zc->api_key;}
		// //else {$this->authtoken = $zc->api_key;}
		// $this->newFormat = $newFormat;

		$this->set_auth($newFormat);
	}
	public function set_auth($newFormat)
	{
		// $this->db->order_by('id', 'desc');
		$this->db->where('id','1');
		$auth_data = $this->db->get('zoho_auth')->row_array();

		// $this->authtoken = 'Zoho-oauthtoken 1000.cc974da174f3e6971f8efc3bfc993846.f0124abe09db92edcba29ec4229acf01';   
		$this->authtoken = 'Zoho-oauthtoken '.$auth_data['access_token'];

		$this->newFormat = $newFormat;

		$db_time_with_increase_time = date('Y-m-d H:i:s', strtotime("+59 minutes", strtotime($auth_data['create_time'])));

		$dtA = strtotime($db_time_with_increase_time);
		$dtB = strtotime(date('Y-m-d H:i:s'));
		$auth_data['create_time'];


        // echo '<pre>';
        // echo 'current server time : ' . date('Y-m-d H:i:s', time()) . '<br>';
        // echo 'Token server time +59 : ' . $db_time_with_increase_time . '<br>';
        // echo 'Token server time : ' . $auth_data['create_time'] . '<br>';
        // echo 'dtA : ' . $dtA . '<br>';
        // echo 'dtB : ' . $dtB . '<br>';
        // exit();

		if ( $dtA < $dtB ) {

			$insArr['refresh_token'] = $data['refresh_token'] = $auth_data['refresh_token'];
			$insArr['client_id']     = $data['client_id'] = $auth_data['client_id'];
			$insArr['client_secret'] = $data['client_secret'] =$auth_data['client_secret'];
			$data['grant_type']      = 'refresh_token';

		  	$token_data    = $this->refresh_authtoken($data);

			$token_dataArr = json_decode($token_data);

			//echo "<pre>"; var_dump($token_data); exit();

			if(isset($token_dataArr->access_token)) {
				$this->authtoken = 'Zoho-oauthtoken '.$token_dataArr->access_token;
			}

			$insArr['access_token'] = "";

			if(isset($token_dataArr->access_token)) {
				$insArr['access_token'] = $token_dataArr->access_token;
			}

			$insArr['authorized_client_name'] = $auth_data['authorized_client_name'];
			$insArr['code'] = $auth_data['code'];
			$insArr['create_time'] = date('Y-m-d H:i:s');

			$this->db->where('id', $auth_data['id']);
			$this->db->update('zoho_auth', $insArr);
		}
		return;
	}
	public function refresh_authtoken($data){
		
		$curl = curl_init();

		curl_setopt_array($curl, array(

			CURLOPT_URL => "https://accounts.zoho.com/oauth/v2/token",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_POSTFIELDS => "------WebKitFormBoundary7MA4YWxkTrZu0gW\r\nContent-Disposition: form-data; name=\"refresh_token\"\r\n\r\n".$data['refresh_token']."\r\n------WebKitFormBoundary7MA4YWxkTrZu0gW\r\nContent-Disposition: form-data; name=\"client_id\"\r\n\r\n".$data['client_id']."\r\n------WebKitFormBoundary7MA4YWxkTrZu0gW\r\nContent-Disposition: form-data; name=\"client_secret\"\r\n\r\n".$data['client_secret']."\r\n------WebKitFormBoundary7MA4YWxkTrZu0gW\r\nContent-Disposition: form-data; name=\"grant_type\"\r\n\r\n".$data['grant_type']."\r\n------WebKitFormBoundary7MA4YWxkTrZu0gW--",
			CURLOPT_HTTPHEADER => array(
				"Cache-Control: no-cache",
				"content-type: multipart/form-data; boundary=----WebKitFormBoundary7MA4YWxkTrZu0gW"
			),
		));

		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);

		if ($err) {
		  return $err;
		} else {
		  return $response;
		}
	}
	public function call_authtoken_refresh()
	{
		$this->db->order_by('id', 'desc');
		$this->db->limit('1');
		$auth_data = $this->db->get('zoho_auth')->row_array();

		// $this->authtoken = 'Zoho-oauthtoken 1000.cc974da174f3e6971f8efc3bfc993846.f0124abe09db92edcba29ec4229acf01';   
		$this->authtoken = 'Zoho-oauthtoken '.$auth_data['access_token'];
		$this->newFormat = 1;

			$insArr['refresh_token'] = $data['refresh_token'] = $auth_data['refresh_token'];
			$insArr['client_id']     = $data['client_id'] = $auth_data['client_id'];
			$insArr['client_secret'] = $data['client_secret'] =$auth_data['client_secret'];
			$data['grant_type']      = 'refresh_token';

		  	$token_data    = $this->refresh_authtoken($data);

			$token_dataArr = json_decode($token_data);

			if(isset($token_dataArr->access_token)) {
				$this->authtoken = 'Zoho-oauthtoken '.$token_dataArr->access_token;
			}

			$insArr['access_token'] = "";

			if(isset($token_dataArr->access_token)) {
				$insArr['access_token'] = $token_dataArr->access_token;
			}

			$insArr['authorized_client_name'] = $auth_data['authorized_client_name'];
			$insArr['code'] = $auth_data['code'];
			$insArr['create_time'] = date('Y-m-d H:i:sa');

			$this->db->where('id', $auth_data['id']);
			$check = $this->db->update('zoho_auth', $insArr);
			if ($check) {
				echo json_encode(['status'=>'success', 'access_token' => $insArr['access_token'] ]);
			}else{
				echo json_encode(['status'=>'failed']);
			}
	}
	public function authtoken_refresh()
	{
		$this->db->order_by('id', 'desc');
		$this->db->limit('1');
		$auth_data = $this->db->get('zoho_auth')->row_array();

		// $this->authtoken = 'Zoho-oauthtoken 1000.cc974da174f3e6971f8efc3bfc993846.f0124abe09db92edcba29ec4229acf01';   
		$this->authtoken = 'Zoho-oauthtoken '.$auth_data['access_token'];
		$this->newFormat = 1;

			$insArr['refresh_token'] = $data['refresh_token'] = $auth_data['refresh_token'];
			$insArr['client_id']     = $data['client_id'] = $auth_data['client_id'];
			$insArr['client_secret'] = $data['client_secret'] =$auth_data['client_secret'];
			$data['grant_type']      = 'refresh_token';

		  	$token_data    = $this->refresh_authtoken($data);

			$token_dataArr = json_decode($token_data);

			if(isset($token_dataArr->access_token)) {
				$this->authtoken = 'Zoho-oauthtoken '.$token_dataArr->access_token;
			}

			$insArr['access_token'] = "";

			if(isset($token_dataArr->access_token)) {
				$insArr['access_token'] = $token_dataArr->access_token;
			}

			$insArr['authorized_client_name'] = $auth_data['authorized_client_name'];
			$insArr['code'] = $auth_data['code'];
			$insArr['create_time'] = date('Y-m-d H:i:sa');

			$this->db->where('id', $auth_data['id']);
			$check = $this->db->update('zoho_auth', $insArr);
			if ($check) {
				echo json_encode(['status'=>'success']);
			}else{
				echo json_encode(['status'=>'failed']);
			}
	}
	public function generateAccessAndRefreshToken($array)
	{
		if(!$array){echo "empty array!"; return false;}

		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => "https://accounts.zoho.com/oauth/v2/token",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_POSTFIELDS => "------WebKitFormBoundary7MA4YWxkTrZu0gW\r\nContent-Disposition: form-data; name=\"code\"\r\n\r\n".$array['code']."\r\n------WebKitFormBoundary7MA4YWxkTrZu0gW\r\nContent-Disposition: form-data; name=\"client_id\"\r\n\r\n".$array['client_id']."\r\n------WebKitFormBoundary7MA4YWxkTrZu0gW\r\nContent-Disposition: form-data; name=\"redirect_uri\"\r\n\r\n".$array['direct_url']."\r\n------WebKitFormBoundary7MA4YWxkTrZu0gW\r\nContent-Disposition: form-data; name=\"client_secret\"\r\n\r\n".$array['client_secret']."\r\n------WebKitFormBoundary7MA4YWxkTrZu0gW\r\nContent-Disposition: form-data; name=\"grant_type\"\r\n\r\nauthorization_code\r\n------WebKitFormBoundary7MA4YWxkTrZu0gW--",
			CURLOPT_HTTPHEADER => array(
				"Cache-Control: no-cache",
				"Postman-Token: cad9a619-db4f-4ab6-bfe4-ac0491b9c17c",
				"content-type: multipart/form-data; boundary=----WebKitFormBoundary7MA4YWxkTrZu0gW"
			),
		));

		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);

		if ($err) {
			return $err;
		} else {
			return $response;
		}
	}

	/*
	* Description: Get record details of any module by its zoho record id
	* Parameters:  $id= A valid Zoho_record_id 
	*              $module= The name of the Zoho Module for which record id is provided
	* Returns: An array(count=>NUMBER_OF_RECORDS, data=array(THE ACTUAL DATA WITH ALL FIELDS AND ITS VALUE AS KEY => VALUE PAIR))
	* Notes: It would be nice to check if getError() method returns any value after calling this function for error handling
	*/

	public function getRecordsById($id, $module)
	{
		if (!$id) return false;
		try
		{
			$records = array();
			$resultAr = array();
			$zoho_url = "https://www.zohoapis.com/crm/v2/$module/$id";
			$result = $this->get_from_zoho($zoho_url);
			
			if(isset($result->data)) $resultAr = $result->data;
			$output = json_encode($resultAr, true);
			$records = json_decode($output, true);
			return array(
				'count' => count($records) ,
				'data' => $records
			);
		}

		catch(Exception $e)
		{
			$this->error = $e->getMessage();
		}
	}

	public function getNotes($id, $module)
	{
		if (!$id) return false;
		try
		{
			$records = array();
			$resultAr = array();
			$zoho_url = "https://www.zohoapis.com/crm/v2/$module/$id/Notes";
			$result = $this->get_from_zoho($zoho_url);
			
			if(isset($result->data)) $resultAr = $result->data;
			$output = json_encode($resultAr, true);
			$records = json_decode($output, true);
			return array(
				'count' => count($records) ,
				'data' => $records
			);
		}

		catch(Exception $e)
		{
			$this->error = $e->getMessage();
		}
	}

	/*
	*Description: Gets related records from zoho module.
	*Parameters:  $module= The name of the Zoho Module for which record list want
	*			  $id= A valid Zoho_record_id 
	*             $parentModule= The name of the Zoho Module for which record id is provided
	*/
	public function getRelatedRecords($module, $id, $parentModule, $maxRecords = 400)
	{
		if (!$id) return false;
		try
		{
			$post = array();
			$post['page']= $page = 1;
			$post['per_page'] = 200;
			$zoho_url = "https://www.zohoapis.com/crm/v2/$parentModule/$id/$module";


			$hasMore = true;
			$records = array();
			$resultAr = array();
			while ($hasMore)
			{
				$result = $this->get_from_zoho($zoho_url);
				if(isset($result->data)) $resultAr = array_merge($resultAr, $result->data);

				$post['page']= $post['page']+1;
				if (!isset($result->data) or count($result->data) < 200 or empty($result->data) or count($resultAr) >= $maxRecords) $hasMore = false;
			}

			$output = json_encode($resultAr, true);
			$records = json_decode($output, true);
			
			return array(
				'count' => count($records) ,
				'data' => $records
			);
		}

		catch(Exception $e)
		{
			$this->error = $e->getMessage();
		}
	}

	/* Description: Gets fields from zoho module
	* Parameters: $type= Specify the value as 1 or 2
	1 - To retrieve all fields from the summary view
	2 - To retrieve all mandatory fields from the module
	$module= The name of the Zoho Module for which record id is provided
	*/
	public function getFields($module, $type = '')
	{
		try
		{
			$post = array();
			$records = array();
			//$post['scope'] = 'ZohoCRM.settings.all';
			$post['module'] = $module;
			
			if($type != ''){
				$post['type'] = "$type";
			}
			
			$url = "https://www.zohoapis.com/crm/v2/settings/fields";

			$fields_string = http_build_query($post, '', "&");
			$zoho_url = $url . "?$fields_string";

			$result = $this->get_from_zoho($zoho_url);
			//echo '<pre>'; print_r(json_decode(json_encode($result), true)); echo '</pre>';exit;

			if(isset($result->fields)) $records = $this->getFieldResult($result->fields);
			
			return $records;
		}

		catch(Exception $e)
		{
			$this->error = $e->getMessage();
		}

		return false;
	}

	public function getFieldResult($zohoResponse)
	{
		if (!$zohoResponse) return false;

		//var_dump($zohoResponse);exit();

		$result = array();
		foreach($zohoResponse as $d)
		{
			$fields = array();
			$secName = $d->field_label;
			
				$tmp = array(
					'field_label' => $d->field_label ,
					'api_name' => $d->api_name ,
					'type' => $d->data_type ,
					'required' => '' ,
					// 'length' => $d->length ,
					'length' => '',
					'isCustom' => $d->custom_field ,
					'isReadOnly' => $d->read_only
				);

				$tmp['lookup_module'] = isset($d->lookup->module) ? $d->lookup->module : "";

				if ($d->data_type == 'picklist')
				{
					$listVals = $d->pick_list_values;
					$vals = array();//new
					foreach($listVals as $v) $vals[] = $v->display_value;
					$tmp['values'] = $vals;
				}

				if ($d->data_type == 'multiselectpicklist')
				{
					$listVals = $d->pick_list_values;
					$vals = array();//new
					foreach($listVals as $v) $vals[] = $v->display_value;
					$tmp['values'] = $vals;
				}
			
			$result[$secName] = $tmp;
		}

		return $result;
	}


	public function getUsers($type = 'AllUsers')
	{
		try
		{
			$post = array();
			$output = '';
			$records = array();
			$post['type'] = $type;
			$url = "https://www.zohoapis.com/crm/v2/users";

			$fields_string = http_build_query($post, '', "&");
			$zoho_url = $url . "?$fields_string";

			$result = $this->get_from_zoho($zoho_url);
			
			if(isset($result->users)) $output = json_encode($result->users, true);
			$records = json_decode($output, true);

			return $records;
		}

		catch(Exception $e)
		{
			$this->error = $e->getMessage();
		}

		return false;
	}

	/*	 
	*	Description: Gets all module list
	*/
	public function getModule()
	{
		try
		{
			$post = array();
			$output = '';
			$records = array();
			$zoho_url = "https://www.zohoapis.com/crm/v2/settings/modules";

			$result = $this->get_from_zoho($zoho_url);

			// echo '<pre>Nzoho getModule result:'; print_r($result); echo '</pre>';
			// exit();
			
			if(isset($result->modules)) $output = json_encode($result->modules, true);
			$records = json_decode($output, true);

			return $records;
		}

		catch(Exception $e)
		{
			$this->error = $e->getMessage();
		}

		return false;
	}

	/*	 
	*Description: Gets search records from pre defined column [email, phone, word as column name]
	*/
	public function getSearchRecordsByPDC($module, $searchColumn, $searchValue, $selectColumns = array() , $maxRecords = 400)
	{
		try
		{
			$post = array();
			if (count($selectColumns)) $selectColumns = implode(',', $selectColumns);
			$post['fields'] = $selectColumns;
			$post[$searchColumn] = $searchValue;
			$post['page'] = 1;
			$post['per_page'] = 200;
			$url = "https://www.zohoapis.com/crm/v2/$module/search";

			$hasMore = true;
			$records = array();
			$resultAr = array();
			while ($hasMore)
			{
				$fields_string = http_build_query($post, '', "&");
				$zoho_url = $url . "?$fields_string";
				
				$result = $this->get_from_zoho($zoho_url);
				if(isset($result->data)) $resultAr = array_merge($resultAr, $result->data);

				$post['page']= $post['page']+1;
				if (!isset($result->data) or count($result->data) < 200 or empty($result->data) or count($resultAr) >= $maxRecords) $hasMore = false;
			}

			$output = json_encode($resultAr, true);
			$records = json_decode($output, true);

			return array(
				'count' => count($records) ,
				'data' => $records
			);
		}

		catch(Exception $e)
		{
			$this->error = $e->getMessage(); 
		}
	}


	public function getRecordsWithIndex($module, $fromIndex = 1)
	{
		$selectColumns = array();
		$maxRecords = 200;
		$sortColumn = 'Modified_Time';
		$sortBy = 'asc';
		
		try
		{
			$post = array();
			if (count($selectColumns)) $selectColumns = implode(',', $selectColumns);
			$post['fields'] = $selectColumns;
			$post['page'] = $fromIndex;
			$post['per_page'] = 200;
			$hasMore = true;
			$post['sort_by'] = $sortColumn;
			$post['sort_order'] = $sortBy;
			$records = array();
			$resultAr = array();
			$url = "https://www.zohoapis.com/crm/v2/$module";
			while ($hasMore)
			{
				$fields_string = http_build_query($post, '', "&");
				$zoho_url = $url . "?$fields_string";

				$result = $this->get_from_zoho($zoho_url);
				if(isset($result->data)) $resultAr = array_merge($resultAr, $result->data);
				
				$post['page']= $post['page']+1;
				if (!isset($result->data) or count($result->data) < 200 or empty($result->data) or count($resultAr) >= $maxRecords) $hasMore = false;
			}

			$output = json_encode($resultAr, true);
			$records = json_decode($output, true);

			return array(
				'count' => count($records) ,
				'data' => $records, 
				'toIndex' => $post['page']
			);
		}

		catch(Exception $e)
		{
			$this->error = $e->getMessage();
		}
	}

	/*
	* Description: search records from criteria [Ex: (((Phone:equals:12345679)AND(Last_Name:equals:Jhon))OR(Email:equals:abc@abc.com))]
	*/
	public function getSearchRecords($module, $searchCondition, $selectColumns = array(), $maxRecords = 400)
	{
		try
		{
			$post = array();
			if (count($selectColumns)) $selectColumns = implode(',', $selectColumns);
			$post['fields'] = $selectColumns;
			$post['criteria'] = $searchCondition;
			$post['page'] = 1;
			$post['per_page'] = 200;
			$url = "https://www.zohoapis.com/crm/v2/$module/search";
			$hasMore = true;
			$records = array();
			$resultAr = array();
			while ($hasMore)
			{
				$fields_string = http_build_query($post, '', "&");
				$zoho_url = $url . "?$fields_string";

				$result = $this->get_from_zoho($zoho_url);

				if(isset($result->data)) $resultAr = array_merge($resultAr, $result->data);
				
				$post['page']= $post['page']+1;
				if (!isset($result->data) or count($result->data) < 200 or empty($result->data) or count($resultAr) >= $maxRecords) $hasMore = false;
			}
			$output = json_encode($resultAr, true);
			$records = json_decode($output, true);
			return array(
				'count' => count($records) ,
				'data' => $records
			);
			
		}

		catch(Exception $e)
		{
			$this->error = $e->getmessage();
		}
	}




	public function getSearchRecordsBypage($module, $searchCondition, $selectColumns = array(), $maxRecords = 200)
	 {
		try
		{
			$post = array();
			if (count($selectColumns)) $selectColumns = implode(',', $selectColumns);
			$post['fields'] = $selectColumns;
			$post['criteria'] = $searchCondition;
			$post['page'] = 1;
			$post['per_page'] = 200;
			$url = "https://www.zohoapis.com/crm/v2/$module/search";
			$hasMore = true;
			$records = array();
			$resultAr = array();
			while ($hasMore)
			{
				$fields_string = http_build_query($post, '', "&");
				$zoho_url = $url . "?$fields_string";

				$result = $this->get_from_zoho($zoho_url);

				if(isset($result->data)) $resultAr = array_merge($resultAr, $result->data);
				
				$post['page']= $post['page']+1;
				if (!isset($result->data) or count($result->data) < 200 or empty($result->data) /*or count($resultAr) >= $maxRecords*/) $hasMore = false;
			}
			$output = json_encode($resultAr, true);
			$records = json_decode($output, true);
			return array(
				'count' => count($records) ,
				'data' => $records
			);
			
		}

		catch(Exception $e)
		{
			$this->error = $e->getmessage();
		}
	}

	/*
	* Description: Gets Custom view records from a zoho module
	* Parameters:  $module= The name of the Zoho Module
	*              $maxRecords= The maximum number of records to be returned
	* Returns: An array(count=>NUMBER_OF_RECORDS, data=array(THE ACTUAL DATA WITH ALL FIELDS AND ITS VALUE AS KEY => VALUE PAIR))
	* Notes: It would be nice to check if getError() method returns any value after calling this function for error handling
	*/
	public function getCVRecords($module, $cvName, $selectColumns = array() , $maxRecords = 400)
	{
		try
		{
			$post = array();
			if (count($selectColumns)) $selectColumns = implode(',', $selectColumns);
			$post['fields'] = $selectColumns;
			$post['page'] = 1;
			$post['per_page'] = 200;
			$post['module'] = $module;
			$hasMore = true;
			$records = array();
			$resultAr = array();
			$url = "https://www.zohoapis.com/crm/v2/settings/custom_views";
			while ($hasMore)
			{
				$fields_string = http_build_query($post, '', "&");
				$zoho_url = $url . "?$fields_string";

				$result = $this->get_from_zoho($zoho_url);
				if(isset($result->custom_views)) $resultAr = array_merge($resultAr, $result->custom_views);
				
				$post['page']= $post['page']+1;
				if (!isset($result->custom_views) or count($result->custom_views) < 200 or empty($result->custom_views) or count($resultAr) >= $maxRecords) $hasMore = false;
			}
			$output = json_encode($resultAr, true);
			$records = json_decode($output, true);

			return array(
				'count' => count($records) ,
				'data' => $records
			);
		}

		catch(Exception $e)
		{
			$this->error = $e->getMessage();
		}
	}

	/*
	* Description: Gets records from a zoho module
	* Parameters:  $module= The name of the Zoho Module
	*              $maxRecords= The maximum number of records to be returned
	*              $recordsPerPage= The number of records in single API call to be fetched. Default is 200
	* Returns: An array(count=>NUMBER_OF_RECORDS, data=array(THE ACTUAL DATA WITH ALL FIELDS AND ITS VALUE AS KEY => VALUE PAIR))
	* Notes: It would be nice to check if getError() method returns any value after calling this function for error handling
	*/
	public function getRecords($module, $cvid=false, $page=1, $selectColumns = array() , $maxRecords = 200, $sortColumn = 'Modified_Time', $sortBy = 'asc')
	{
		try
		{
			$post = array();
			$hasMore = true;
			$records = array();

			$url = "https://www.zohoapis.com/crm/v2/$module";
			
			if (count($selectColumns)) $selectColumns = implode(',', $selectColumns);
			$post['fields'] = $selectColumns;
			$post['sort_order'] = 'desc';
			$post['page'] = $page;
			$post['per_page'] = 200;
			
			if( $cvid ){
				$post['cvid'] = $cvid;
			}
			
			$resultAr = array();
			
			while ($hasMore)
			{
				$fields_string = http_build_query($post, '', "&");
				$zoho_url = $url . "?$fields_string";

				$result = $this->get_from_zoho($zoho_url);
				if(isset($result->data)) $resultAr = array_merge($resultAr, $result->data);
				
				$post['page']= $post['page']+1;
				if (!isset($result->data) or count($result->data) < 200 or empty($result->data) or count($resultAr) >= $maxRecords) $hasMore = false;
				
			}

			$output = json_encode($resultAr, true);
			$records = json_decode($output, true);
			
			return array(
				'count' => count($records) ,
				'data' => $records,
				'page' => $page
			);
		}

		catch(Exception $e)
		{
			$this->error = $e->getMessage();
		}
	}

	/*Description: Gets records from a zoho module
	*Parameters:  $module= The name of the Zoho Module*/
	function getMyRecords($module, $selectColumns = array() , $maxRecords = 400, $sortColumn = 'Modified_Time', $sortBy = 'asc')
	{
		try
		{
			$post = array();
			if (count($selectColumns)) $selectColumns = implode(',', $selectColumns);
			$post['fields'] = $selectColumns;
			$post['page'] = 1;
			$post['per_page'] = 200;
			$hasMore = true;
			$post['sort_by'] = $sortColumn;
			$post['sort_order'] = $sortBy;
			$records = array();
			$resultAr = array();
			$url = "https://www.zohoapis.com/crm/v2/$module";
			while ($hasMore)
			{
				$fields_string = http_build_query($post, '', "&");
				$zoho_url = $url . "?$fields_string";

				$result = $this->get_from_zoho($zoho_url);
				if(isset($result->data)) $resultAr = array_merge($resultAr, $result->data);
				
				$post['page']= $post['page']+1;
				if (!isset($result->data) or count($result->data) < 200 or empty($result->data) or count($resultAr) >= $maxRecords) $hasMore = false;
			}
			$output = json_encode($resultAr, true);
			$records = json_decode($output, true);

			return array(
				'count' => count($records) ,
				'data' => $records
			);
		}

		catch(Exception $e)
		{
			$this->error = $e->getMessage();
		}
	}


	//// Sync Records 


	function getRecordsByPage($module, $page=1, $selectColumns = array() , $sortColumn = 'Modified_Time', $sortBy = 'asc')

	{
		try
		{
			$post = array();
			if (count($selectColumns)) $selectColumns = implode(',', $selectColumns);
			$post['fields'] = $selectColumns;
			$post['page'] = $page;
			$post['per_page'] = 200;
			$hasMore = true;
			$post['sort_by'] = $sortColumn;
			$post['sort_order'] = $sortBy;
			if( !empty($_GET['cvid']) ){
				$post['cvid'] = $_GET['cvid'];
			}
			$records = array();
			$resultAr = array();
			$url = "https://www.zohoapis.com/crm/v2/$module";
			while ($hasMore)
			{
				$fields_string = http_build_query($post, '', "&");
				$zoho_url = $url . "?$fields_string";

				$result = $this->get_from_zoho($zoho_url);

				//print_r($result);
			
				if(isset($result->data)) $resultAr = array_merge($resultAr, $result->data);
				
				$post['page']= $post['page']+1;
				if (!isset($result->data) or count($result->data) < 200 or empty($result->data) or count($resultAr) >= 200) $hasMore = false;
			}
			$output = json_encode($resultAr, true);
			$records = json_decode($output, true);

			return array(
				'count' => count($records) ,
				'data' => $records
			);
		}

		catch(Exception $e)
		{
			$this->error = $e->getMessage();
		}
	}




	private function get_from_zoho($url){
		
		$authtoken = $this->authtoken;
		
		$curl = curl_init();
		curl_setopt_array($curl, array(
		  CURLOPT_URL => $url,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => "",
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 30,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => "GET",
		  CURLOPT_HTTPHEADER => array(
		    "Authorization: ".$authtoken
		  ),
		));

		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);

		if ($err) {
		  echo "cURL Error #:" . $err;
		} else {
		  return json_decode($response);
		}
	}

	/*
	* Description: Used for inserting the records
	*/
	public function insertRecords($data = array() , $module = '', $wfTrigger = true, $isApproval = 'false', $duplicateCheck = 2)
	{
		try
		{
			$post = $this->makeJsonNew($data,$wfTrigger);

			$zoho_url = "https://www.zohoapis.com/crm/v2/$module";
			$result = $this->post_to_zoho($zoho_url, $post);
			
			return json_decode($result);
		}
		catch(Exception $e)
		{
			$this->error = $e->getMessage();
		}
	}

	public function updateTag($module, $record_id, $tag_name)
	{
		try
		{

			$zoho_url = "https://www.zohoapis.com/crm/v2/".$module."/".$record_id."/actions/add_tags?tag_names=".rawurlencode($tag_name);
			$result = $this->post_to_zoho_tag($zoho_url);
			
			return json_decode($result);
		}
		catch(Exception $e)
		{
			$this->error = $e->getMessage();
		}
	}

	//Insert purchase order
	public function insertRecordsPO($data, $module){
		try
		{
			$jsonpost = json_encode($data);
			$post = '{"data": '.$jsonpost.',"trigger": ["workflow"]}';
			
			$zoho_url = "https://www.zohoapis.com/crm/v2/$module";
			$result = $this->post_to_zoho($zoho_url, $post);
			
			return json_decode($result);
		}
		catch(Exception $e)
		{
			$this->error = $e->getMessage();
		}
	}

	/*
	*Json return in this format:
	*For one array:
	*{"data": [{"Company": "Acme Inc","Last_Name": "Donelly","First_Name": "Jennifer","Email": "jennifer@acme.com"}],"trigger": ["approval"]}
	*
	*For Multiple array
	*{"data": [{"Company": "Acme Inc","Last_Name": "Donelly","First_Name": "Jennifer","Email": "jennifer@acme.com"},{"Company": "abc Inc","Last_Name": "Test","First_Name": "Jhn","Email": "abcd@acme.com"}],"trigger": ["approval"]}
	*/
	function makeJson($data){
		$str = '';
		foreach ($data as $key => $value) {
			$post = json_encode($value, JSON_FORCE_OBJECT);
    		$str .= $post.',';
		}
		$strtrim = rtrim($str,',');
		$post = '{"data": ['.$strtrim.'],"trigger": ["workflow"]}';

		return $post;
	}


	function makeJsonUpsert($data,$duplicate){
		$str = '';
		foreach ($data as $key => $value) {
			$post = json_encode($value, JSON_FORCE_OBJECT);
    		$str .= $post.',';
		}
		$strtrim = rtrim($str,',');
		$post = '{"data": ['.$strtrim.'],"duplicate_check_fields" : ["'.$duplicate.'"],"trigger": ["workflow"]}';
		//$post = '{"data": ['.$strtrim.'],"trigger": ["workflow"]}';

		//var_dump($post);

		return $post;
	}

	// Amiruzzaman on 24-02-01

	function makeJsonUpsertPayment($data,$duplicate){

		$str = '';
		foreach ($data as $key => $value) {
			$post = json_encode($value, JSON_FORCE_OBJECT);
    		$str .= $post.',';
		}
		$strtrim = rtrim($str,',');
		$post = '{"data": ['.$strtrim.'],"duplicate_check_fields" : ["'.$duplicate.'"],"trigger": ["workflow"]}';
		//$post = '{"data": ['.$strtrim.'],"trigger": ["workflow"]}';

		//var_dump($post);

		return $post;
	}




	function makeJsonNew($data,$wfTrigger = true){
		
		$jsonpost = json_encode($data);

		if($wfTrigger)
		$post = '{"data": '.$jsonpost.',"trigger": ["workflow"]}';
		else
			$post = '{"data": '.$jsonpost.',"trigger": [""]}';

		return $post;
	}


	function post_to_zoho($zoho_url, $fields){
		
		$authtoken = $this->authtoken;

		$ch = curl_init(); 
		curl_setopt($ch, CURLOPT_URL, $zoho_url); 
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
		curl_setopt($ch, CURLOPT_POSTFIELDS, $fields); 
		curl_setopt($ch, CURLOPT_POST, 1); 
		$headers = array(); 
		$headers[] = "Authorization: ".$authtoken; 
		$headers[] = "Content-Type: application/json"; 
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers); 
		
		$response = curl_exec($ch); 
		$err = curl_errno($ch);
		curl_close ($ch);
		if ($err) {
		  return $err;
		} else {
		  return $response;
		}
	}

	function post_to_zoho_tag($zoho_url){
		
		$authtoken = $this->authtoken;
		$ch = curl_init(); 
		curl_setopt($ch, CURLOPT_URL, $zoho_url); 
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1); 
		$headers = array(); 
		$headers[] = "Authorization: ".$authtoken; 
		//$headers[] = "Content-Type: application/json"; 
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers); 
		
		$response = curl_exec($ch);
		$err = curl_errno($ch);
		curl_close ($ch);
		if ($err) {
		  return $err;
		} else {
		  return $response;
		}
	}


	public function updateRecords($id = '',$data = array() , $module = '', $wfTrigger = true)
	{
		try
		{
			$post = array();
			$data[0]['id'] = $id;

			$post = $this->makeJsonNew($data,$wfTrigger);

			$zoho_url = "https://www.zohoapis.com/crm/v2/$module";

			$result = $this->update_to_zoho($zoho_url, $post);
			
			return json_decode($result);
		}

		catch(Exception $e)
		{
			$this->error = $e->getMessage();
		}
	}

	public function updateRecordsPO($id,$data, $module){
		try
		{
			$data[0]['id'] = $id;
			$jsonpost = json_encode($data);
			$post = '{"data": '.$jsonpost.',"trigger": ["workflow"]}';
			
			$zoho_url = "https://www.zohoapis.com/crm/v2/$module";
			$result = $this->update_to_zoho($zoho_url, $post);

			//dd( $result );
			
			return json_decode($result);
		}
		catch(Exception $e)
		{
			$this->error = $e->getMessage();
		}
	}

	public function updateRecordsPONew($data, $module){
		try
		{
			//$data[0]['id'] = $id;
			$jsonpost = json_encode($data);
			$post = '{"data": '.$jsonpost.',"trigger": [""]}';
			
			$zoho_url = "https://www.zohoapis.com/crm/v2/$module";
			$result = $this->update_to_zoho($zoho_url, $post);

			//dd( $result );
			
			return json_decode($result);
		}
		catch(Exception $e)
		{
			$this->error = $e->getMessage();
		}
	}

	 public function updateRelatedRecords($id = '',$data = array() , $parentModule = '', $related_module = '', $related_module_id = '')
    {
        try
        {
            $post = array();
            $data[0]['id'] = $id;
           	$post = $this->makeJson($data);
            $zoho_url = "https://www.zohoapis.com/crm/v2/$parentModule/$id/$related_module/$related_module_id";
           	$result = $this->update_to_zoho($zoho_url, $post);
        	return json_decode($result);
		}

		catch(Exception $e)
		{
			$this->error = $e->getMessage();
		}
    }



// public function updateRelatedRecords($id,$data = array() , $module, $related_module)
//     {
//         try
//         {
//             $post = array();
//             $post['authtoken'] = $this->authtoken;
//             $post['scope'] = "crmapi";
//             $post['id'] = $id;
//             $post['relatedModule'] = $related_module;
//             $post['xmlData'] = $this->xmlData($data, $module);
//             //print_r($post); die;
//             $zoho_url = "https://crm.zoho.com/crm/private/xml/$module/updateRelatedRecords";
//             $result = $this->post_to_zoho($zoho_url, $post);
//             //echo $result; die;
//             if (count($data) > 1) return $this->getMultiInsertResult($result);
//             else return $this->getInsertResult($result);
//         }

//         catch(Exception $e)
//         {
//             $this->error = $e->getMessage();
//         }
//     }



    public function updateNotes($id,$data = array())
    {
    	try
    	{
    		$post = array();

    		$jsonpost = json_encode($data);

			$post = '{"data": [ '.$jsonpost.' ] }';

    		$zoho_url = "https://www.zohoapis.com/crm/v2/Notes/".$id;

    		$result = $this->update_to_zoho($zoho_url, $post);
    		
    		return json_decode($result);
    	}

    	catch(Exception $e)
    	{
    		$this->error = $e->getMessage();
    	}
    }

    public function CreateNotes($note_content,$module,$module_id)
    {
    	try
    	{
    		$post = array();

    		$data = array(
    				"Note_Content" => $note_content,
    				"Parent_Id" => $module_id,
    				"se_module" => $module
    			);

    		$jsonpost = json_encode($data);

			$post = '{"data": [ '.$jsonpost.' ] }';

    		$zoho_url = "https://www.zohoapis.com/crm/v2/".$module."/".$module_id."/Notes";

    		$result = $this->post_to_zoho($zoho_url, $post);
    		
    		return json_decode($result);
    	}

    	catch(Exception $e)
    	{
    		$this->error = $e->getMessage();
    	}
    }

    

	function update_to_zoho($zoho_url, $fields){
		$authtoken = $this->authtoken;

		$ch = curl_init(); 
		curl_setopt($ch, CURLOPT_URL, $zoho_url); 
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);  
		curl_setopt($ch, CURLOPT_POSTFIELDS, $fields); 
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT"); 
		$headers = array(); 
		$headers[] = "Authorization: ".$authtoken; 
		$headers[] = "Content-Type: application/json";  
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers); 
		$response = curl_exec($ch); 
		$err = curl_errno($ch);

		//dd( $response );
		
		curl_close ($ch);
		if ($err) {
		  return $err;
		} else {
		  return $response;
		}

	}


	/*
	* Description: Used for inserting/updating the records [update if exists]
	* In data array, should be pass [id] for update
	*/

	public function upsertRecordsPO($data = array() ,$module = '',$duplicate = ''){
		try
		{
			//$data[0]['id'] = $id;
			$jsonpost = json_encode($data);
			//$post = '{"data": ['.$jsonpost.'],"duplicate_check_fields" : ["'.$duplicate.'"],"trigger": ["workflow"]}';
			$post = '{"data": '.$jsonpost.',"duplicate_check_fields" : ["'.$duplicate.'"],"trigger": ["workflow"]}';
			
			$zoho_url = "https://www.zohoapis.com/crm/v2/$module/upsert";
			$result = $this->post_to_zoho($zoho_url, $post);

			//dd( $result );
			
			return json_decode($result);
		}
		catch(Exception $e)
		{
			$this->error = $e->getMessage();
		}
	}

	public function upsertRecords($data = array() ,$module = '',$duplicate = ''){
		try
		{
			$post = array();

			$post = $this->makeJsonUpsert($data,$duplicate);
			$zoho_url = "https://www.zohoapis.com/crm/v2/$module/upsert";

			$result = $this->post_to_zoho($zoho_url, $post);
			
			return json_decode($result);
		}

		catch(Exception $e)
		{
			$this->error = $e->getMessage();
		}
	}

	// Amiruzzaman 24-02-21
	
	public function upsertRecordsPayment($data = array() ,$module = '',$duplicate = ''){
		try
		{
			$post = array();

			$post = $this->makeJsonUpsertPayment($data,$duplicate);
			$zoho_url = "https://www.zohoapis.com/crm/v2/$module/upsert";

			$result = $this->post_to_zoho($zoho_url, $post);
			
			return json_decode($result);
		}

		catch(Exception $e)
		{
			$this->error = $e->getMessage();
		}
	}




	public function deleteRecords($id , $module)
	{
		try
		{
			$post = array();
			$post['ids'] = $id;
			$url = "https://www.zohoapis.com/crm/v2/$module";

			$fields_string = http_build_query($post, '', "&");
			$zoho_url = $url . "?$fields_string";

			$result = $this->delete_from_zoho($zoho_url);

			return $result;
			
		}

		catch(Exception $e)
		{
			$this->error = $e->getMessage();
		}
	}

	/*
	*Delete file
	*Description: Used for deleting the files
	*/
	//change [Add parameter => attachment_id]
	public function deleteFile($module, $id, $attachment_id)
	{
		try
		{
			$zoho_url = "https://www.zohoapis.com/crm/v2/$module/$id/Attachments/$attachment_id";

			$result = $this->delete_from_zoho($zoho_url);
			return $result;
		}

		catch(Exception $e)
		{
			$this->error = $e->getmessage();
		}
	}

	/*Download file
	*Description: Used for downloading file
	*/
	//change [Add parameter => attachment_id]
	public function downloadFile($module, $id, $attachment_id)
	{
		try
		{
			$post['scope'] = 'ZohoCRM.modules.'.$module.'.all';
			$url = "https://www.zohoapis.com/crm/v2/$module/$id/Attachments/$attachment_id";

			$fields_string = http_build_query($post, '', "&");
			$zoho_url = $url . "?$fields_string";

			$result = $this->download_from_zoho($zoho_url);
			
			return true;
			// return $result;
		}

		catch(Exception $e)
		{
			$this->error = $e->getmessage();
		}
	}

	/*
	*Upload file
	*Description: Used for uploading the record
	*/

	// public function uploadFile($module,$content, $id)
	// {

	// 	try
	// 	{
	// 		$authtoken = $this->authtoken;
	// 		//$post['file'] = new CurlFile($content);

			
	// 		//$post['file'] =  class_exists('CurlFile', false) ? new CURLFile($content) : '@' . $content;
	// 		$post['file'] = '@'. $content;
	// 		//dd( $post['file'] );
	// 		$ffilesize = filesize($content);
	// 		if ($ffilesize >  20000000){
	// 			die("File size must be less than 20MB");
	// 		}			

	// 		$zoho_url = "https://www.zohoapis.com/crm/v2/$module/$id/Attachments";

	// 		$result = $this->upload_to_zoho($zoho_url, $post);
	// 		$records = json_decode($result, true);

	// 		return $records;
			
	// 	}

	// 	catch(Exception $e)
	// 	{
	// 		$this->error = $e->getmessage();
	// 	}

	// }

	/*public function uploadFile($module,$content,$file_path, $id)
	{
		try
		{
			$authtoken = $this->authtoken;
			$post['file'] = new CURLFile($content);
			$ffilesize = filesize($file_path);

			if ($ffilesize > 20000000){
				die("File size must be less than 20MB");
			}			

			echo $zoho_url = "https://www.zohoapis.com/crm/v2/$module/$id/Attachments";

			$result = $this->upload_to_zoho($zoho_url, $post);
			$records = json_decode($result);
			return $records;
		}
		catch(Exception $e)
		{
			$this->error = $e->getmessage();
		}
	}*/

	public function uploadFile($module,$content, $id)
	{
		try
		{
			$newFormat = 1;

			$this->set_auth($newFormat);

			$authtoken = $this->authtoken;
			$post['file'] = new CurlFile($content);
			//var_dump($post);exit();
			$post['file'] =  class_exists('CurlFile', false) ? new CURLFile($content) : '@' . $content;
			$ffilesize = filesize($content);
			if ($ffilesize >  20000000)
			{
				return "File size must be less than 20MB";
			}			

			$zoho_url = "https://www.zohoapis.com/crm/v2/$module/$id/Attachments";
			$result = $this->upload_to_zoho($zoho_url, $post);
			$records = json_decode($result, true);

			return $records;
			
		}

		catch(Exception $e)
		{
			$this->error = $e->getmessage();
		}

	}

	/*
	*Upload filed file
	*Description: Used for uploading the record
	*/
	public function uploadFieldFile($content)
	{
		try
		{
			$authtoken = $this->authtoken;
			$post['file'] = new \CURLFile($content);
			$ffilesize = filesize($content);
			if ($ffilesize >  20000000)
			{
				die("File size must be less than 20MB");
			}			

			$zoho_url = $this->url."/crm/v2/files";

			$result = $this->upload_to_zoho($zoho_url, $post);
			$records = json_decode($result);

			return $records;
			
		}

		catch(Exception $e)
		{
			$this->error = $e->getmessage();
		}

	}

	

	public function downloadPhoto($module, $id)
	{
		try
		{
			$zoho_url = "https://www.zohoapis.com/crm/v2/$module/$id/photo";
			$result = $this->download_from_zoho($zoho_url);
			
			return $result;
		}

		catch(Exception $e)
		{
			$this->error = $e->getmessage();
		}
	}

	public function deletePhoto($module, $id)
	{
		try
		{
			$zoho_url = "https://www.zohoapis.com/crm/v2/$module/$id/photo";
			$result = $this->delete_from_zoho($zoho_url);
			
			return $result;
		}

		catch(Exception $e)
		{
			$this->error = $e->getmessage();
		}
	}

	public function uploadPhoto($module,$content, $id)
	{
		try
		{
			$post = array();
			$post['file'] = new CurlFile($content);
			$ffilesize = filesize($content);
			if ($ffilesize >  20000000)
			{
				die("File size must be less than 20MB");
			}
			
			$zoho_url = "https://www.zohoapis.com/crm/v2/$module/$id/photo";
			$result = $this->upload_to_zoho($zoho_url, $post);
			$records = json_decode($result, true);

			return $records;			
			
		}

		catch(Exception $e)
		{
			$this->error = $e->getmessage();
		}
		
	}


	function download_from_zoho($zoho_url){
		$authtoken = $this->authtoken;
		$ch = curl_init(); 
		curl_setopt($ch, CURLOPT_URL, $zoho_url); 
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET"); 
		$headers = array(); 
		$headers[] = "Authorization: ".$authtoken; 
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers); 
		
		$response = curl_exec($ch); 
		$err = curl_errno($ch);
		
		curl_close ($ch);
		if ($err) {
		  return $err;
		} else {
		  return $response;
		}

	}

	

	private function delete_from_zoho($url){
		
		$authtoken = $this->authtoken;
		
		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");

		$headers = array();
		$headers[] = "Authorization: ".$authtoken;
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$response = curl_exec($ch); 
		$err = curl_errno($ch);
		
		curl_close ($ch);
		if ($err) {
		  return $err;
		} else {
		  return $response;
		}


	}


	function upload_to_zoho($zoho_url, $fields){
		
		$authtoken = $this->authtoken;

		$ch=curl_init();
		curl_setopt($ch, CURLOPT_VERBOSE, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE); 
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch,CURLOPT_URL,$zoho_url);
		curl_setopt($ch,CURLOPT_POSTFIELDS,$fields);
		$headers = array(); 
		$headers[] = "Authorization: ".$authtoken; 
		$headers[] = "Content-Type: multipart/form-data"; 
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers); 

		$response = curl_exec($ch); 
		$err = curl_errno($ch);
		
		curl_close ($ch);
		if ($err) {
		  return $err;
		} else {
		  return $response;
		}
	}



function sync_getRecordsById($crmid='',$module=''){ 

	set_time_limit(186400); 

	// if(isset($_GET['crmid'], $_GET['module'])){}else{echo "Paramiter Missing";
	// 	exit();
	// }

	// $crmid = $_GET['crmid'];
	// $module = ucfirst($_GET['module']);	

	//$n_module = $this->getModuleApiname($module);

	$result = $this->getRecordsById($crmid, $module);

	if($result['count']>0){
		foreach($result['data'] as $data){
			// echo "<pre>";var_dump($data);echo "</pre>";

			$table_name = 'BP_'.$module;

			if ($this->db->table_exists($table_name)) {
	      		$this->saveDataToDb($table_name,$data);
	      	}else echo $table_name."  table is not existis.";

	      	      		            

		}
	}

} // end syncZohoModule


function saveDataToDb($table,$data)
	{

		$fieldList =  $this->getTableColumns($table);

		$insertArr = array();
		$uc=0;

		$this->db->where('module_id', $data['id']); 
		$this->db->delete($table); 
		foreach ($data as $key => $value) {

			if (strpos($key, '$') !== false) {}
			else{
				if($key == 'id'){
					$insertArr['module_id'] = $value;
				}

				else if($key == 'Product_Details' && $table == 'BP_Quotes')
				{
					$insertArr['Product_Details'] = json_encode($value);

					//$this->saveQuoteProduct($value,$data['id']);
				}

				else if($key == 'Product_Details' && $table == 'BP_PurchaseOrders')
				{
					$insertArr['Product_Details'] = json_encode($value);

					//$this->savePOproduct($value,$data['id'],$data['Quote']['id'],$data['Item_Receipt']);
				}

				else if($key == 'Product_Details' && $table == 'BP_Invoices')
				{
					$insertArr['Product_Details'] = json_encode($value);

					//$this->saveinvproduct($value,$data['id']);
				}

				else if($key == 'Product_Details' && $table == 'BP_Invoices')
				{
					$insertArr['Product_Details'] = json_encode($value);

					
				}


				else{

					if(is_array($value)){
						foreach ($value as $key1 => $val) {
							if($key1 == 'id'){
								if (in_array($key.'_ID', $fieldList)) {
									if(is_array($val))$val = json_encode($val);
									$insertArr[$key.'_ID'] = $val;
								}else {//echo '</br>'.$key.'->'.$key1." == Not Found</br>";$uc++;
							}
							}else if($key1 == 'name'){
								if (in_array($key, $fieldList)) {
									if(is_array($val))$val = json_encode($val);
									$insertArr[$key] = $val;
								}else {//echo '</br>'.$key.'->'.$key1." == Not Found</br>";$uc++;
							}
							}else{
								// if (in_array($key, $fieldList)) {
								// 	if(is_array($val))$val = json_encode($val);
								// 	$insertArr[$key] = $val;
								// }else {echo '</br>'.$key.'->'.$key1." == Not Found</br>";$uc++;}
							}
						}
					}else{
						if (in_array($key, $fieldList)) {
							$insertArr[$key] = $value;
						}else {//echo '</br>'.$key." == Not Found</br>";$uc++;
					}
					}
				}
			}
		}

		//echo "</br>Unknown Column = ".$uc;

		if(isset($insertArr['Modified_Time']))$insertArr['Modified_Time'] = date("Y-m-d H:i:s",strtotime($insertArr['Modified_Time']));
		if(isset($insertArr['Created_Time']))$insertArr['Created_Time'] = date("Y-m-d H:i:s",strtotime($insertArr['Created_Time']));
		if(isset($insertArr['Last_Activity_Time']))$insertArr['Last_Activity_Time'] = date("Y-m-d H:i:s",strtotime($insertArr['Last_Activity_Time']));

		//echo "<pre>";var_dump($insertArr);echo "</pre>";
		

    	if ($this->db->table_exists($table)) $this->db->insert($table, $insertArr);
		//echo "</br>Insert";    	

	}

		function getTableColumns($table)
	{
        if ($this->db->table_exists($table)){
			return $this->db->list_fields($table);
		}else return false;
	}
	
 

	
}


/*****************************************************************/
/**********************Testing of the Class***********************/
/*****************************************************************/


/*****************************************************************/
/*****Example of data array to be passed in various methods*******/
/*****************************************************************/
/*
$data=array(

array(
'Company' => 'R Square G Web',
'First Name' => 'John',
'Email' => 'ramkumar15685@gmail.com', 
'Last Name' => 'Doe'
),
array(
'Company' => 'R Square G Web',
'First Name' => 'Gaurav',
'Last Name' => 'Gupta'
)
);
*/
/*****************************************************************/
/*****Example of data array to be passed in various methods*******/
/*****************************************************************/
/*$test = new Zoho('d33dbd9c6d3e854682c3af81efe9604b', 1);
$result = $test->convertLead('531636000000061001');
$test->debug($result);*/