
function initializeWidget() {
	/*
	 * Subscribe to the EmbeddedApp onPageLoad event before initializing the widget 
	 * https://www.zoho.com/crm/developer/docs/javascript-sdk/sample-codes.html
	 * https://help.zwidgets.com/help/latest/index.html
	 */
	ZOHO.embeddedApp.on("PageLoad", function (data) {
		// moment.tz.setDefault("Australia/Melbourne");

		var record_id = "";
		var ajaxRootUrl = "https://aucrm.authorsunbound.com/speakerflow_new/";
		var speakerId = "";
		var calendarEl;
		var calendar;
		var calInitialDate = moment().format("YYYY-MM-DD");
		var timeZoneSettings = "+10:00";
		var timeZoneCountry = "Australia/Melbourne";

		ZOHO.CRM.UI.Resize({ height: "700", width: "2000" }).then(function (data) {
			// console.log(data);
		});

		// initialize Calendar
		calendarEl = document.getElementById('deal_calendar_main');

		if (data && data.Entity) {
			record_id = data.EntityId;
			load_initial_data(record_id, 1);
		}
		// console.log(data);

		function initializePlugin() {
			$("[data-toggle='popover']").popover();
			$("[data-toggle='tooltip']").tooltip();
			// $(".fieldDate").datepicker({
			// 	dateFormat: 'dd-mm-yy',
			// 	changeMonth: true,
			// 	changeYear: true
			// });
			$('.fieldDate').datetimepicker({
				timepicker: false,
				format: 'm-d-Y',
				timepickerScrollbar: false,
				scrollInput: false,
				scrollMonth: false
			});
			$("#date_months").datepicker({
				dateFormat: 'MM yy',
				changeMonth: true,
				changeYear: true,
				onClose: function (dateText, inst) {
					$(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
				}
			});
		}

		function load_initial_data(frecord_id = record_id, page = 1) {
			record_id = frecord_id;
			speakerId = frecord_id;
			loadCalendar();
			initializePlugin();
			//pull_speaker_opp_linking(record_id);
			//loadManualEvents(speakerId);
			//loadManualEvents(speakerId);
		}

		//Start edit event name

		$(document).on("click",".edit-event-name",function(){

			$(".event-name-box").hide();
			$(".event-name-for-edit").show();

		});

		$(document).on("click",".submit-event-name",function(){

			var thisPointer = $(this);
			$.ajax({
				type: "POST",
				enctype: 'multipart/form-data',
				url: ajaxRootUrl + "manual_event.php",
				data: {actfor: "updateEvent", title: $(this).closest("div").find('.edit-event-name-value').val(), id: $(this).closest(".event-detail").find('.event-id-for-edit').val()},
				cache: false,
				timeout: 800000,
				dataType: "json",
				success: function (data) {
					// $("#output").text(data);
					console.log("SUCCESS : ", data);
					// $("#btnSubmit").prop("disabled", false);
					if (data.status == "success") {
						console.log(thisPointer.closest('div').find(".edit-event-name-value").val());
						$("#actionViewEventModalManual .event-title").html(thisPointer.closest('div').find(".edit-event-name-value").val());
						$(".event-name-box").show();
		    			$(".event-name-for-edit").hide();
						calendar.removeAllEvents();
						//$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
						loadCalendar();
					}
				},
				error: function (e) {
					console.log("ERROR : ", e);
				}
			});

		});

		//End edit event name

		$(document).on("click",".edit-start-date",function(){

			$(".start-date-box").hide();
			$(".start-date-box-for-edit").show();

		});

		$(document).on("click",".edit-end-date",function(){

			$(".end-date-box").hide();
			$(".end-date-box-for-edit").show();

		});

		$('#actionViewEventModalManual').on('hidden.bs.modal', function () {
		    $(".start-date-box").show();
		    $(".start-date-box-for-edit").hide();
		    $(".event-name-box").show();
		    $(".event-name-for-edit").hide();
		    $(".end-date-box").show();
		    $(".end-date-box-for-edit").hide();
		    $(".event-edit-original").show();
		    $(".edit-description").show();
		    $(".ev-description-edit").hide();
		    $(".edit-description-ok").hide();
		    $(".event-note-content-original").show();
		    $(".event-note-content-for-edit").hide();
		});

		$(document).on("click",".submit-start-date",function(){

			var thisPointer = $(this);
			$.ajax({
				type: "POST",
				enctype: 'multipart/form-data',
				url: ajaxRootUrl + "manual_event.php",
				data: {actfor: "updateEvent", start: moment($(this).closest("div").find('.edit-start-date-value').val(), 'MM-DD-YYYY HH:mm').format("YYYY-MM-DD HH:mm"), id: $(this).closest(".event-detail").find('.event-id-for-edit').val()},
				cache: false,
				timeout: 800000,
				dataType: "json",
				success: function (data) {
					// $("#output").text(data);
					console.log("SUCCESS : ", data);
					// $("#btnSubmit").prop("disabled", false);
					if (data.status == "success") {
						console.log(thisPointer.closest('div').find(".edit-start-date-value").val());
						$("#actionViewEventModalManual .event-date").html(moment(thisPointer.closest('div').find(".edit-start-date-value").val()).format("MM-DD-YYYY"));
						$(".start-date-box").show();
						$(".start-date-box-for-edit").hide();
						calendar.removeAllEvents();
						//$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
						loadCalendar();
					}
				},
				error: function (e) {
					console.log("ERROR : ", e);
				}
			});

		});

		$(document).on("click",".submit-end-date",function(){

			var thisPointer = $(this);
			$.ajax({
				type: "POST",
				enctype: 'multipart/form-data',
				url: ajaxRootUrl + "manual_event.php",
				data: {actfor: "updateEvent", end: moment($(this).closest("div").find('.edit-end-date-value').val(), 'MM-DD-YYYY HH:mm').format("YYYY-MM-DD HH:mm"), id: $(this).closest(".event-detail").find('.event-id-for-edit').val()},
				cache: false,
				timeout: 800000,
				dataType: "json",
				success: function (data) {
					// $("#output").text(data);
					console.log("SUCCESS : ", data);
					// $("#btnSubmit").prop("disabled", false);
					if (data.status == "success") {
						$("#actionViewEventModalManual .event-last-day").html(moment(thisPointer.closest('div').find(".edit-end-date-value").val()).format("MM-DD-YYYY"));
						$(".end-date-box").show();
						$(".end-date-box-for-edit").hide();
						calendar.removeAllEvents();
						//$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
						loadCalendar();
					}
				},
				error: function (e) {
					console.log("ERROR : ", e);
				}
			});

		});

		$(document).on("click",".edit-description",function(){

			$(".event-edit-original").hide();
			$(".ev-description-edit").show();
			$(".edit-description-ok").show();

		});

		$(document).on("click",".edit-description-ok",function(){

			var thisPointer = $(this);
			$.ajax({
				type: "POST",
				enctype: 'multipart/form-data',
				url: ajaxRootUrl + "manual_event.php",
				data: {actfor: "updateEvent", description: $(this).closest(".event-detail").find('.ev-description-edit').val(), id: $(this).closest(".event-detail").find('.event-id-for-edit').val()},
				cache: false,
				timeout: 800000,
				dataType: "json",
				success: function (data) {
					// $("#output").text(data);
					console.log("SUCCESS : ", data);
					// $("#btnSubmit").prop("disabled", false);
					if (data.status == "success") {
						$("#actionViewEventModalManual .event-description-manual").html(thisPointer.closest(".event-detail").find('.ev-description-edit').val());
						$(".event-edit-original").show();
						$(".edit-description").show();
						$(".ev-description-edit").hide();
						$(".edit-description-ok").hide();
						calendar.removeAllEvents();
						//$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
						loadCalendar();
					}
				},
				error: function (e) {
					console.log("ERROR : ", e);
				}
			});

		});

		//start edit note

		$(document).on("click",".edit-note",function(){

			$(this).closest(".note-wrapper").find(".event-note-content-original").hide();
			$(this).closest(".note-wrapper").find(".event-note-content-for-edit").show();

		});

		$(document).on("click",".edit-note-done",function(){

			var thisPointer = $(this);
			$.ajax({
				type: "POST",
				enctype: 'multipart/form-data',
				url: ajaxRootUrl + "manual_event.php",
				data: {actfor: "updateNote", notes: $(this).closest(".note-wrapper").find('textarea').val(), id: $(this).data("noteid")},
				cache: false,
				timeout: 800000,
				dataType: "json",
				success: function (data) {
					// $("#output").text(data);
					console.log("SUCCESS : ", data);
					// $("#btnSubmit").prop("disabled", false);
					if (data.status == "success") {
						thisPointer.closest(".note-wrapper").find(".main-note-content").html(thisPointer.closest(".note-wrapper").find('textarea').val());
						thisPointer.closest(".note-wrapper").find(".event-note-content-original").show();
						thisPointer.closest(".note-wrapper").find(".event-note-content-for-edit").hide();
						calendar.removeAllEvents();
						//$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
						loadCalendar();
					}
				},
				error: function (e) {
					console.log("ERROR : ", e);
				}
			});

		});

		$(document).on("click",".edit-crm-note-done",function(){

			thisPointer = $(this);

			var config={
			  Entity:"Notes",
			  APIData:{
			        "id": $(this).data("noteid"),
			        "Note_Content": $(this).closest(".note-wrapper").find('textarea').val()
			  }
			}
			console.log( config );
			ZOHO.CRM.API.updateRecord(config)
			.then(function(data){
				console.log("Note Update Info");
			    console.log(data);
			    thisPointer.closest(".note-wrapper").find(".main-note-content").html(thisPointer.closest(".note-wrapper").find('textarea').val());
			    thisPointer.closest(".note-wrapper").find(".event-note-content-original").show();
			    thisPointer.closest(".note-wrapper").find(".event-note-content-for-edit").hide();
			});

		});

		$(document).on('click', '.delete-note', function (e) {
			//$("#actionViewEventModalManual").modal('hide');
			var note_id = $(this).data("noteid");
			var thisPointer = $(this);

			$('<div></div>').appendTo('body').html('<div><h6>Are you sure?</h6></div>').dialog({
				modal: true,
				title: 'Delete',
				zIndex: 10000,
				autoOpen: true,
				width: '500px',
				resizable: false,
				buttons: {
					Yes: function () {
						// $(obj).removeAttr('onclick');                                
						// $(obj).parents('.Parent').remove();
						// $('body').append('<h1>Confirm Dialog Result: <i>Yes</i></h1>');
						const _thisDialog = $(this);
						var fd = new FormData();
						fd.append('actfor', "deletenote");
						fd.append('note_id', note_id);
						$.ajax({
							type: "POST",
							enctype: 'multipart/form-data',
							url: ajaxRootUrl + "manual_event.php",
							data: fd,
							processData: false,
							contentType: false,
							cache: false,
							timeout: 800000,
							dataType: "json",
							success: function (data) {
								console.log("SUCCESS : ", data);
								_thisDialog.dialog("close");
								if (data.status == "success") {
									// loadCalendar([]);
									thisPointer.closest(".note-wrapper").remove();
									calendar.removeAllEvents();
									//$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
									loadCalendar();
								}
							},
							error: function (e) {
								console.log("ERROR : ", e);
								_thisDialog.dialog("close");
							}
						});

						// $(this).dialog("close");
					},
					No: function () {
						// $('body').append('<h1>Confirm Dialog Result: <i>No</i></h1>');
						$(this).dialog("close");
					}
				},
				close: function (event, ui) {
					$(this).remove();
				}
			});

			return false;
		});

		$(document).on('click', '.delete-crm-note', function (e) {
			//$("#actionViewEventModal").modal('hide');
			var note_id = $(this).data("noteid");
			var thisPointer = $(this);

			$('<div></div>').appendTo('body').html('<div><h6>Are you sure?</h6></div>').dialog({
				modal: true,
				title: 'Delete',
				zIndex: 10000,
				autoOpen: true,
				width: '500px',
				resizable: false,
				buttons: {
					Yes: function () {
						const _thisDialog = $(this);
						ZOHO.CRM.API.deleteRecord({Entity:"Notes",RecordID: note_id})
						.then(function(data){
							console.log("Note delete info");
						    console.log(data);
						    _thisDialog.dialog("close");
						    thisPointer.closest(".note-wrapper").remove();
						})
					},
					No: function () {
						// $('body').append('<h1>Confirm Dialog Result: <i>No</i></h1>');
						$(this).dialog("close");
					}
				},
				close: function (event, ui) {
					$(this).remove();
				}
			});

			return false;
		});

		//end edit note

		/*$(document).on('change', '.deal_speaker', function (e) {
			speakerId = $(this).val();
			if (speakerId != "") {
				$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
				// loadCalendar([]);
				calendar.removeAllEvents();
				pull_speaker_opp_linking(speakerId);
				//loadManualEvents(speakerId);
			} else {
				// loadCalendar([]);
				calendar.removeAllEvents();
			}
		});*/

		$(document).on('click', '.speaker-name', function (e) {
			speakerId = $(this).data("speakerid");
			$(".speaker-name").removeClass("active");
			$(this).addClass("active");
			if (speakerId != "") {
				$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
				// loadCalendar([]);
				calendar.removeAllEvents();
				pull_speaker_opp_linking(speakerId);
				//loadManualEvents(speakerId);
			} else {
				// loadCalendar([]);
				calendar.removeAllEvents();
			}
		});

		function pull_speaker_opp_linking(speakerId, page = 1) {

			// ZOHO.CRM.API.searchRecord({Entity:"Opportunities_X_Speakers",sort_order:"desc", sort_by:"Created_Time",Type:"criteria",Query:"((Related_Opportunities:equals:"+record_id+") and (Shortlisted_Speakers:equals:"+speakerId+") AND (Track_Month:equals:" + moment(calInitialDate).format("YYYY-MM") + "))", per_page:200,page:page})

			return new Promise((resolve, reject) => {
				ZOHO.CRM.API.getRelatedRecords({ Entity: "Authors", RecordID: speakerId, RelatedList: "Confirmed_Deals", page: page, per_page: 200 })
					.then(function (response) {
						if (response.data) {
							finalData = response.data;
							//$.LoadingOverlay("show");
							console.log("check resolve");
							prepareRelatedOpportunities(finalData).then(function(){resolve();});
							//resolve();
						}else{
							console.log("check reject");
							resolve();
						}
					});
				//resolve();
			});

			/*ZOHO.CRM.API.searchRecord({ Entity: "Deals", sort_order: "desc", sort_by: "Created_Time", Type: "criteria", Query: "((Confirmed_Author:equals:" + speakerId + "))", per_page: 200, page: page })
				.then(function (response) {
					// console.log(response)
					if (response.info && response.info.more_records == true) {
						$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
						pull_speaker_opp_linking(record_id, (page + 1))
					} else {
						$(".msg_div").html('');
					}
					if (response.data) {
						$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
						finalData = response.data;
						prepareRelatedOpportunities(finalData);
					}
				}).catch(function (ex) {
					console.log("ex : ", ex);
					$(".msg_div").html('');
				});*/

			// .fail(function() {
			// 	//handle error here
			// 	console.log("asasfasf")
			//   });
		}

		async function pull_speaker_not_confirmed(speakerId, page = 1) {

			//$.LoadingOverlay("show");

			return new Promise(async (resolve, reject) => {

				try {

					const response = await ZOHO.CRM.API.getRelatedRecords({
					            Entity: "Authors",
					            RecordID: speakerId,
					            RelatedList: "Deals1",
					            page: 1,
					            per_page: 200
					        });

					if (response.data) {
			            const finalData = response.data;
			            // console.log("shoukhin");
			            // console.log(finalData);

			            // Uncomment the lines below if you want to use the data inside the jQuery.each loop
			            //$(".deal_speaker").empty();
			            //$(".deal_speaker").append('<option value="">-None-</option>');
			            let allFoundedDeals = [];
			            // Using regular for loop with async/await
			            for (let i = 0; i < finalData.length; i++) {
			                // Process each item in the loop
			                const item = finalData[i];
			                let dealInfo = await fetch_deal_details_by_id(item.Suggested_Deals.id);
			                if( dealInfo[0].Confirmed_Author == null ){
			                	allFoundedDeals.push(dealInfo[0]);
			                }
			            }

			            console.log("allFoundedDeals");
			            console.log(allFoundedDeals);
			            // if (allFoundedDeals.length === 0) {
			            // 	$.LoadingOverlay("hide");
			            // }else{
			            	//await prepareRelatedOpportunities(allFoundedDeals);
			            prepareRelatedOpportunities(allFoundedDeals).then(function(){resolve();}).catch(error => {
									console.log("error 4");
									console.log(error);
							    	resolve();
							  });
			            //}
			         	//resolve(); 
			        }
			        else{
			        	resolve();
			        	//$.LoadingOverlay("hide");
			        }

				} catch (error) {
					//$.LoadingOverlay("hide");
			        console.error("Error fetching related records:", error);
			        resolve();
			    }
			});

		}

		async function fetch_deal_details_by_id(deal_id) {
		    const dealInfo = await ZOHO.CRM.API.getRecord({
		     	Entity: "Deals", RecordID:deal_id
		    });

		    if( dealInfo.data ){
		    	return dealInfo.data;
		    }else{
		    	return null;
		    }
		}


		function loadCalendar(calEvents = []) {

			calendar = new FullCalendar.Calendar(calendarEl, {
				initialView: 'dayGridMonth',
				initialDate: calInitialDate,
				//aspectRatio: 2.7, //height of row
				selectable: true,
				events: calEvents,
				displayEventTime: false,
				customButtons: {
			      myCustomButton: {
			        text: 'Refresh',
			        click: function() {
			          // Handle button click event
			          refresh_widget();
			        }
			      }
			    },
			    headerToolbar: {
			      left: 'dayGridMonth,timeGridWeek,timeGridDay,listWeek',
			      //center: 'title',
			      right: 'prev,next today myCustomButton' // Add the custom button to the header
			    },
			    buttonText: {
			        today: 'Today', // Custom text for the 'today' button
			        month: 'Month', // Custom text for the 'month' button
			        week: 'Week',   // Custom text for the 'week' button
			        day: 'Day',     // Custom text for the 'day' button
			        list: 'List',   // Custom text for the 'list' button
			        // Add any other custom button texts you want to change
			    },
			    eventDidMount: function(info) {
		          // Add ribbon for one-day events
		          if (info.event.end - info.event.start <= 24 * 60 * 60 * 1000) {
		          	var dotElement = info.el.querySelector('.fc-daygrid-event-dot');
		          	if( dotElement != null ){
		          		dotElement.style.display = 'none';
		          	}
		            /*var titleElement = info.el.querySelector('.fc-event-title');
		            titleElement.style.backgroundColor = 'yellow';*/
		          }
		        },
				eventClick: function (info) {
					console.log(info.event);
					let evSt = (info.event.start != "" && info.event.start != null) ? moment(info.event.start).format("MM-DD-YYYY") : "";
					let evEd = (info.event.end != "" && info.event.end != null) ? moment(info.event.end).format("MM-DD-YYYY") : "";
					if (info.event.extendedProps.type == "crm") {
						console.log(info);
						$("#actionViewEventModal .event-title").html(info.event.title);
						$("#actionViewEventModal .event-deal").html('<a target="_blank" href="https://crm.zoho.com/crm/org812409302/tab/Deals/' + info.event.extendedProps.itemInfo.id + '">' + info.event.extendedProps.itemInfo.Deal_Name + '</a>');
						if( info.event.extendedProps.itemInfo.Confirmed_Author != null ){
							console.log( info.event.extendedProps.itemInfo.Confirmed_Author );
							$("#actionViewEventModal .event-confirmed-author").html('<a target="_blank" href="https://crm.zoho.com/crm/org812409302/tab/CustomModule6/' + info.event.extendedProps.itemInfo.Confirmed_Author.id + '">' + info.event.extendedProps.itemInfo.Confirmed_Author.name + '</a>');
						}
						$("#actionViewEventModal .suggested-authors").html("");
						ZOHO.CRM.API.getRelatedRecords({ Entity: "Deals", RecordID: info.event.extendedProps.itemInfo.id, RelatedList: "Authors1", page: 1, per_page: 200 })
							.then(function (response) {
								if (response.data) {
									finalData = response.data;
									//$(".deal_speaker").empty();
									//$(".deal_speaker").append('<option value="">-None-</option>');
									if (finalData.length > 0) {
										//speakerId = finalData[0].Suggested_Authors.id;
										jQuery.each(finalData, function (i, item) {
											let Shortlisted_Speaker = (item.Suggested_Authors) ? item.Suggested_Authors.name : "";
											let Shortlisted_Speaker_Id = (item.Suggested_Authors) ? item.Suggested_Authors.id : "";
											//$(".deal_speaker").append('<option value="' + Shortlisted_Speaker_Id + '">' + Shortlisted_Speaker + '</option>');
											$("#actionViewEventModal .suggested-authors").append('<li><a target="_blank" href="https://crm.zoho.com/crm/org812409302/tab/CustomModule6/' + Shortlisted_Speaker_Id + '">' + Shortlisted_Speaker + '</a></li>');
										});
									}
								}
							});

						if( info.event.extendedProps.itemInfo.Account_Name != null ){
							$("#actionViewEventModal .event-account-name").html('<a target="_blank" href="https://crm.zoho.com/crm/org812409302/tab/Accounts/' + info.event.extendedProps.itemInfo.Account_Name.id + '">' + info.event.extendedProps.itemInfo.Account_Name.name + '</a>');
						}
						$("#actionViewEventModal .event-date").html(moment(info.event.extendedProps.itemInfo.Event_Date).format("MM-DD-YYYY"));
						$("#actionViewEventModal .event-last-day").html(moment(info.event.extendedProps.itemInfo.Last_Day_of_Event).format("MM-DD-YYYY"));
						$("#actionViewEventModal .event-format").html(info.event.extendedProps.itemInfo.Event_Medium);
						$("#actionViewEventModal .event-city").html(info.event.extendedProps.itemInfo.Event_City);
						$("#actionViewEventModal .event-state").html(info.event.extendedProps.itemInfo.Event_State);
						$("#actionViewEventModal .saveEventNote").data("moduleid", info.event.extendedProps.itemInfo.id);
						$("#actionViewEventModal .saveEventNote").data("module", "Deals");
						$("#actionViewEventModal").data("moduleid", info.event.extendedProps.itemInfo.id);
						$("#actionViewEventModal").data("module", "Authors");
						$("#actionViewEventModal .event-notes").html("");
						load_event_notes(info.event.extendedProps.itemInfo.id, "Deals");
						$("#actionViewEventModal .eventDelete").hide();
						$("#actionViewEventModal .eventDeleteRecur").hide();
						$("#actionViewEventModal").modal("show");
					} else{
						$("#actionViewEventModalManual .event-title").html(info.event.extendedProps.modalEventName);
						$("#actionViewEventModalManual .edit-event-name-value").val(info.event.extendedProps.modalEventName);
						ZOHO.CRM.API.getRecord({
						 Entity: "Authors", RecordID:info.event.extendedProps.itemInfo.speaker_id
						})
						.then(function(data){
							console.log(data.data);
						    $("#actionViewEventModalManual .event-link-author").html('<a target="_blank" href="https://crm.zoho.com/crm/org812409302/tab/CustomModule6/' + info.event.extendedProps.itemInfo.speaker_id + '">' + data.data[0].Name + '</a>');
						    $("#actionViewEventModalManual .author-id-for-edit").val(info.event.extendedProps.itemInfo.speaker_id);
						});
						$("#actionViewEventModalManual .event-description-manual").html(info.event.extendedProps.itemInfo.description);
						$("#actionViewEventModalManual .ev-description-edit").val(info.event.extendedProps.itemInfo.description);
						$("#actionViewEventModalManual .saveEventNote").data("moduleid", info.event.id);
						$("#actionViewEventModalManual .saveEventNote").data("module", "CustomEvent");
						$("#actionViewEventModalManual").data("moduleid", info.event.id);
						$("#actionViewEventModalManual").data("module", "CustomEvent");
						$("#actionViewEventModalManual .event-date").html(moment(info.event.extendedProps.itemInfo.start).format("MM-DD-YYYY"));
						$("#actionViewEventModalManual .edit-start-date-value").val(moment(info.event.extendedProps.itemInfo.start).format("MM-DD-YYYY"));
						$("#actionViewEventModalManual .event-last-day").html(moment(info.event.extendedProps.itemInfo.end).format("MM-DD-YYYY"));
						$("#actionViewEventModalManual .edit-end-date-value").val(moment(info.event.extendedProps.itemInfo.end).format("MM-DD-YYYY"));
						$("#actionViewEventModalManual .event-notes").html('');
						$("#actionViewEventModalManual .event-id-for-edit").val(info.event.id);
						load_manual_notes(info.event.id);
						$("#actionViewEventModalManual .eventDelete").show();

						$("#actionViewEventModalManual .eventDeleteRecur").hide();

						$("#actionViewEventModalManual").modal("show");
					}
				},
				select: function (info, jsEvent, view) {
					$("#actionEventModal").find(".evStartDate").val(moment(info.start).format("MM-DD-YYYY"));
					$("#actionEventModal").find(".evEndDate").val(moment(info.start).format("MM-DD-YYYY"));
					$("#actionEventModal").modal("show");
				},
				datesSet: function (info) {
					buildMonthList();
					//$(".msg_div").html('');
				},

			});
			calendar.render();

			initializePlugin();
		}

		function loadEventInCalendar(calEvents = [], isRemove = "") {
			// removeEvents = calendar.getEventSources();
			// removeEvents.forEach(event => {
			// 	console.log("event: ", event)
			// 	// event.remove();
			// });
			// calendar.removeAllEvents();
			return new Promise(async (resolve, reject) => {
				console.log("here I am");

				await Promise.all($.each(calEvents, function (key, item) {
					// calendar.removeEvents(item.id);
					// $('#speaker_calendar_main').fullCalendar('removeEvents', item.id);
					console.log(item);
					calendar.addEvent(item);
				}));

				resolve();
			});
			//$.LoadingOverlay("hide");
		}

		function load_event_notes(module_id, module, page = 1) {
			ZOHO.CRM.API.getRelatedRecords({ Entity: module, RecordID: module_id, RelatedList: "Notes", page: page, per_page: 200 })
				.then(function (response) {
					console.log(response)
					if (response.data) {
						finalData = response.data;
						$.each(finalData, function (key, item) {
							$("#actionViewEventModal .event-notes").append('<div class="note-wrapper"><div class="event-note-content event-note-content-original"><span class="main-note-content">' + item.Note_Content + '</span>&nbsp;&nbsp;&nbsp;<span><i class="fa-solid fa-trash delete-crm-note" data-noteid="'+item.id+'" style="cursor: pointer; font-size: 14px; color: #dc3545;"></i></span>&nbsp;&nbsp;&nbsp;<span><i class="fa-solid fa-pencil edit-note" style="cursor: pointer; font-size: 14px;"></i></span></div><div class="event-note-content-for-edit event-note-content" style="display:none; padding-top:13px;"><textarea class="form-control">' + item.Note_Content + '</textarea>&nbsp;&nbsp;&nbsp;<span><i class="fa-solid fa-save edit-crm-note-done" data-noteid="'+item.id+'" style="cursor: pointer; font-size: 14px;"></i></span></div></div>');
							//$("#actionViewEventModal .event-notes").append('<div class="event-note-content">' + item.Note_Content + '</div>');
						});
					}
				})
		}

		function prepareRelatedOpportunities(data) {
			console.log(data);

			return new Promise(async (resolve, reject) => {
				if (data.length > 0) {
					var buildingEvents = await Promise.all($.map(data, function (item) {
						// if ((item.Status != "") && (item.Status != "null") && (item.Status != null) && (item.Hold_Date != "") && (item.Hold_End_Date != "")) {
						if ((item.Event_Date != "")) {
							console.log(item);
							//let itStatus = (item.Status != "") && (item.Status != "null") && (item.Status != null) ? item.Status + ' - ' : "";

							/*if( item.Stage == "Outreach" || item.Stage == "Conversation" ){
								var selectedClass = "dealOpen";
							}else */if( item.Stage == "Offer" || item.Stage == "Confirmation" ){
								var selectedClass = "dealOpen";//"dealPending";
							}else if( item.Stage == "Pre-Itinerary" || item.Stage == "Itinerary in Progress" || item.Stage == "Pre-Event" || item.Stage == "Post-Event" || item.Stage == "Event Complete" ){
								var selectedClass = "dealWon";
							}

							if( item.Stage != "Lost" && item.Stage != "Outreach" && item.Stage != "Conversation" ){


								return {
									id: item.id,
									type: "crm",
									itemInfo: item,
									content: "",
									title: (item.Event_Name == null)?item.Deal_Name:item.Event_Name,
									start: (item.Event_Date != "" && (item.Event_Date != null)) ? moment(item.Event_Date).format("YYYY-MM-DD HH:mm") : "",
									end: (item.Last_Day_of_Event != "" && (item.Last_Day_of_Event != null)) ? moment(item.Last_Day_of_Event).format("YYYY-MM-DD 23:00") : moment(item.Event_Date).format("YYYY-MM-DD 23:00"),
									className: ["event", selectedClass],
									//color: 'red'
								};

							}

						}
					}));

					setTimeout(async () => {
						// console.log(buildingEvents);
						console.log("from related");
						loadEventInCalendar(buildingEvents).then(function(){resolve();});
						;
						//$.LoadingOverlay("hide");
					}, 3000);
				}else{
					resolve();
				}
			});
			// else{
			// 	$.LoadingOverlay("hide");
			// }
		}

		function loadManualEvents(record_id) {
			console.log("check speaker id");
			console.log( record_id );
			return new Promise((resolve, reject) => {
				$.ajax({
					type: 'POST',
					url: ajaxRootUrl + "manual_event.php",
					data: {
						spid: record_id,
						selecteddate: calInitialDate,
						actfor: "getevents",
					},
					dataType: "json",
					success: async function (data) {
						if (data.status == "success") {
							// $(".msg_div").html(data.message);
							// setTimeout(function(){
							// 	$(".msg_div").html("");
							// }, 2000);
							// $(".CustomEvent").closest(".fc-timegrid-event-harness").remove();
							// $(".CustomEvent").closest(".fc-daygrid-event-harness").remove();
							await prepareManualEvents(data.data);
							resolve();
						}
					},
					error: function (error) {
						console.log(error);
						resolve();
					}
				});
			});
		}

		function load_manual_notes(event_id) {
			console.log("event_id "+ event_id);
			$.ajax({
				type: 'POST',
				url: ajaxRootUrl + "manual_event.php",
				data: {
					event_id: event_id,
					actfor: "getnotes",
				},
				dataType: "json",
				success: function (data) {
					if (data.status == "success") {
						finalData = data.data;
						$.each(finalData, function (key, item) {
							$("#actionViewEventModalManual .event-notes").append('<div class="note-wrapper"><div class="event-note-content event-note-content-original"><span class="main-note-content">' + item.notes + '</span>&nbsp;&nbsp;&nbsp;<span><i class="fa-solid fa-trash delete-note" data-noteid="'+item.id+'" style="cursor: pointer; font-size: 14px; color: #dc3545;"></i></span>&nbsp;&nbsp;&nbsp;<span><i class="fa-solid fa-pencil edit-note" style="cursor: pointer; font-size: 14px;"></i></span></div><div class="event-note-content-for-edit event-note-content" style="display:none; padding-top:13px;"><textarea class="form-control">' + item.notes + '</textarea>&nbsp;&nbsp;&nbsp;<span><i class="fa-solid fa-save edit-note-done" data-noteid="'+item.id+'" style="cursor: pointer; font-size: 14px;"></i></span></div></div>');
						});
					}
				},
				error: function (error) {
					console.log(error);
				}
			})
		}

		function fetch_speaker_details_by_id(speakerId) {

	    	return new Promise(resolve => {
		        // Simulate an API call using setTimeout
		        setTimeout(() => {
	                const response = ZOHO.CRM.API.getRecord({
	            				Entity: "Authors", RecordID:speakerId
	            			});
	                // console.log("hello 2");
	                // console.log( response );
		            resolve(response);
		        }, 1000);
		    });

		}

		async function prepareManualEvents(data) {
			// console.log(data.length);
			if (data.length > 0) {
				//$.LoadingOverlay("show");
				var buildingEvents = await Promise.all($.map(data, async function (item) {
					// if((item.Status != "") && (item.Hold_Date != "") && (item.Hold_End_Date != "")){

					const speakerDetails = await fetch_speaker_details_by_id(item.speaker_id);

					console.log("hello");
					console.log( speakerDetails.data[0].Name );
					console.log( item.speaker_id );

					return {
						id: item.id,
						type: "manual",
						itemInfo: item,
						title: speakerDetails.data[0].Name + ' - ' +item.title,
						modalEventName: item.title,
						content: item.notes,
						start: (item.start != "" && (item.start != null)) ? moment(item.start).format("YYYY-MM-DD HH:mm") : "",
						end: (item.end != "" && (item.end != null)) ? moment(item.end).format("YYYY-MM-DD 23:00") : "",
						className: ["event", item.id + "_cEvent CustomEvent"],
						// textColor:"#000",
						// backgroundColor: '#fff'
					};
					// }
				}));

				// setTimeout(async () => {
				// 	console.log("from manual");
				// 	console.log(buildingEvents);
				// 	//$.LoadingOverlay("hide");
				await loadEventInCalendar(buildingEvents);
				// }, 3000);
			}
		}

		$(document).on("change", "#recurringCheck", function () {
			if ($(this).is(':checked')) {
				$(".for_recurring").show();
				$(".evEndDateDiv").hide();
				$(".evEndDate").val($(".evStartDate").val());
				$(".for_recurring .evUnit").prop("required", true);
				$(".for_recurring .evInterval").prop("required", true);
			} else {
				$(".for_recurring").hide();
				$(".evEndDateDiv").show();
				$(".for_recurring").find(":input").prop("required", false);
				$(".for_recurring .evUnit").val("");
				$(".for_recurring .evInterval").val("");
				$(".for_recurring .evUntil").val("");
			}
		})

		//Save manual event 
		$(".saveEventForm").submit(function (e) {
			//prevent Default functionality
			e.preventDefault();
			var fd = new FormData($(this)[0]);
			fd.append('actfor', "saveevent");
			fd.append('speaker_id', speakerId);
			fd.append('start', moment($(this).find('.evStartDate').val(), 'MM-DD-YYYY HH:mm').format("YYYY-MM-DD HH:mm"));
			fd.append('end', moment($(this).find('.evEndDate').val(), 'MM-DD-YYYY HH:mm').format("YYYY-MM-DD HH:mm"));
			// let rec_until = ($(this).find('.evUntil').val() != "") ? moment($(this).find('.evUntil').val(), 'MM-DD-YYYY').format("YYYY-MM-DD") : "";
			// fd.append('rec_until', rec_until);

			let stDate = moment($(this).find('.evStartDate').val(), 'MM-DD-YYYY HH:mm').format("YYYY-MM-DD HH:mm");
			let enDate = moment($(this).find('.evEndDate').val(), 'MM-DD-YYYY HH:mm').format("YYYY-MM-DD HH:mm");
			if (stDate > enDate) {
				$(".evErrMsg").html('<span class="text-danger">Start Date can not be greated than end date.</span>');
				return false;
			} /*else if ((rec_until != "") && (stDate > rec_until)) {
				$(".evErrMsg").html('<span class="text-danger">Start Date can not be greated than until date.</span>');
				return false;
			}*/ else {
				$(".evErrMsg").html('');
				$.ajax({
					type: "POST",
					enctype: 'multipart/form-data',
					url: ajaxRootUrl + "manual_event.php",
					data: fd,
					processData: false,
					contentType: false,
					cache: false,
					timeout: 800000,
					dataType: "json",
					success: function (data) {
						// $("#output").text(data);
						console.log("SUCCESS : ", data);
						// $("#btnSubmit").prop("disabled", false);
						if (data.status == "success") {
							$("#actionEventModal input").val("");
							$("#actionEventModal textarea").val("");
							//$("#actionEventModal #recurringCheck").prop("checked", false);
							$("#actionEventModal").modal("hide");
							// loadManualEvents(speakerId);
							// refresh_widget();

							var fValYMDst = new Date(stDate).toLocaleString("en-US", { timeZone: timeZoneCountry });
							var fValYMDed = (enDate != "") ? new Date(enDate).toLocaleString("en-US", { timeZone: timeZoneCountry }) : fValYMDst;
							console.log("--stDate = " + stDate);
							console.log("--enDate = " + enDate);
							console.log("--fValYMDst = " + fValYMDst);
							console.log("--fValYMDed = " + fValYMDed);
							console.log("--speakerId = " + speakerId);
							//conflict_check_manual(speakerId, fValYMDst, fValYMDed);

							// loadCalendar([]);
							calendar.removeAllEvents();
							//$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
							// pull_speaker_opp_linking(speakerId);
							// loadManualEvents(speakerId);
							loadCalendar();
						}
					},
					error: function (e) {
						console.log("ERROR : ", e);
					}
				});
			}

		});

		function conflict_check_manual(speaker_id, stVal, edVal) {
			ZOHO.CRM.API.searchRecord({ Entity: "Opportunities_X_Speakers", sort_order: "desc", sort_by: "Created_Time", Type: "criteria", Query: "(Shortlisted_Speakers:equals:" + speaker_id + ")", per_page: 200, page: 1 })
				.then(function (response) {
					var fmodule = "Opportunities_X_Speakers";

					console.log("onAssign Conflict ins stVal :" + stVal);
					console.log("onAssign Conflict ins date stVal :" + new Date(stVal));

					console.log("onAssign Conflict ins edVal :" + edVal);
					console.log("onAssign Conflict ins date edVal :" + new Date(edVal));

					if (response.data) {
						jQuery.each(response.data, function (i, item) {
							console.log("onAssign Conflict item Hold_Date id :" + item.id);
							console.log("onAssign Conflict item Hold_Date tt :" + item.Hold_Date);
							console.log("onAssign Conflict item Hold_End_Date tt :" + item.Hold_End_Date);

							console.log("onAssign Conflict item Hold_Date :" + new Date(item.Hold_Date));
							console.log("onAssign Conflict item Hold_End_Date :" + new Date(item.Hold_End_Date));

							if ((new Date(stVal) >= new Date(item.Hold_Date)) && (new Date(stVal) <= new Date(item.Hold_End_Date)) || (new Date(edVal) >= new Date(item.Hold_Date)) && (new Date(edVal) <= new Date(item.Hold_End_Date)) ) {

								var upd_conf = {
									Entity: fmodule,
									APIData: {
										"id": item.id,
										"Conflict_Check": "Conflict found. Please visit the Speaker's record and reference the Speaker Calendar to resolve.",
									},
									// Trigger:["workflow"]
								};
								ZOHO.CRM.API.updateRecord(upd_conf).then(function (cresponse) {
									console.log(cresponse)
									if (cresponse.data && cresponse.data[0].code == "SUCCESS") {
										// 	//If you do anything after success
										// refresh_widget();
									}
								});
								return false;
							}
						});
					}
				});
		}


		$(document).on('click', '.saveEventNote', function (e) {
			var event_note = $(this).closest("form").find(".event-note").val();
			if (event_note.trim() == "") {
				$(".msg_div").html('<span class="text-danger">Note field can not be empty.</span>');
				return false;
			}
			var module_id = $(this).data("moduleid");
			var module = $(this).data("module");
			console.log("module_id = ", module_id)
			console.log("module = ", module);
			var thisPointer = $(this);
			if (module == "CustomEvent" && module_id != "") {
				var fd = new FormData();
				fd.append('actfor', "savenote");
				fd.append('event_id', module_id);
				fd.append('notes', event_note);
				fd.append('speaker_id', speakerId);
				$.ajax({
					type: "POST",
					enctype: 'multipart/form-data',
					url: ajaxRootUrl + "manual_event.php",
					data: fd,
					processData: false,
					contentType: false,
					cache: false,
					timeout: 800000,
					dataType: "json",
					success: function (data) {
						// $("#output").text(data);
						console.log("SUCCESS : ", data);
						// $("#btnSubmit").prop("disabled", false);
						if (data.status == "success") {
							thisPointer.closest("form").find(".event-notes").html("");
							thisPointer.closest("form").find(".event-note").val("");
							load_manual_notes(module_id);
						}
					},
					error: function (e) {
						console.log("ERROR : ", e);
					}
				});



			} else if (module != "" && module_id != "") {
				var recordData = {
					"Parent_Id": module_id,
					"se_module": module,
					"Note_Content": event_note
				}
				ZOHO.CRM.API.insertRecord({ Entity: "Notes", APIData: recordData, Trigger: [] }).then(function (data) {
					if (data.data && data.data[0].code == "SUCCESS") {
						thisPointer.closest("form").find(".event-notes").html("");
						thisPointer.closest("form").find(".event-note").val("");
						load_event_notes(module_id, module);
					} else {
						console.log(data);
					}
				});
			}
		});

		$(document).on('focus click', '.hoverEdit', function (e) {
			$(".saveCancelSpan").hide();
			$(this).closest(".editorDiv").find(".saveCancelSpan").show();
		});
		$(document).on('click', '.cancelAct', function (e) {
			$(".saveCancelSpan").hide();
			// $(this).closest(".editorDiv").find(".saveCancelSpan").hide();
		});


		$(document).on('click', '.eventDelete', function (e) {
			$("#actionViewEventModalManual").modal('hide');
			var module_id = $("#actionViewEventModalManual").data("moduleid");
			var module = $("#actionViewEventModalManual").data("module");
			var recurring = $("#actionViewEventModalManual").data("recurring");
			var recparent = $("#actionViewEventModalManual").data("recparent");
			console.log(recurring);
			console.log(recparent);

			$('<div></div>').appendTo('body').html('<div><h6>Are you sure?</h6></div>').dialog({
				modal: true,
				title: 'Delete',
				zIndex: 10000,
				autoOpen: true,
				width: '500px',
				resizable: false,
				buttons: {
					Yes: function () {
						// $(obj).removeAttr('onclick');                                
						// $(obj).parents('.Parent').remove();
						// $('body').append('<h1>Confirm Dialog Result: <i>Yes</i></h1>');
						const _thisDialog = $(this);
						var fd = new FormData();
						fd.append('actfor', "deleteevent");
						fd.append('event_id', module_id);
						fd.append('recurring', recurring);
						fd.append('recparent', recparent);
						$.ajax({
							type: "POST",
							enctype: 'multipart/form-data',
							url: ajaxRootUrl + "manual_event.php",
							data: fd,
							processData: false,
							contentType: false,
							cache: false,
							timeout: 800000,
							dataType: "json",
							success: function (data) {
								console.log("SUCCESS : ", data);
								if (data.status == "success") {
									// loadCalendar([]);
									calendar.removeAllEvents();
									//$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
									loadCalendar();
								}
								_thisDialog.dialog("close");
							},
							error: function (e) {
								console.log("ERROR : ", e);
								_thisDialog.dialog("close");
							}
						});

						// $(this).dialog("close");
					},
					No: function () {
						// $('body').append('<h1>Confirm Dialog Result: <i>No</i></h1>');
						$(this).dialog("close");
					}
				},
				close: function (event, ui) {
					$(this).remove();
				}
			});


		});

		$('#date_months').on('change', function () {
			const selectedDate = moment($(this).val(), 'MMMM YYYY').format("YYYY-MM-01")
			calendar.gotoDate(selectedDate);
		});

		// buildMonthList();
		function buildMonthList() {
			var month = calendar.getDate();
			console.log("month = ", month)
			$("#date_months").val(moment(month).format('MMMM YYYY'));
			calInitialDate = moment(month).format("YYYY-MM-DD");
			console.log("calInitialDate : ", calInitialDate);

			calendar.removeAllEvents();
			if (speakerId != "") {
				$.LoadingOverlay("show");
				loadManualEvents(speakerId).then(async function(){
					pull_speaker_opp_linking(speakerId, 1).then(function(){
						pull_speaker_not_confirmed(speakerId).then(function(){
							$.LoadingOverlay("hide");}
						).catch(error => {
							console.log("error 1");
							console.log(error);
						    $.LoadingOverlay("hide");
						  });
					}).catch(error => {
						console.log("error 2");
						console.log(error);
					    $.LoadingOverlay("hide");
					  });
				}).catch(error => {
					console.log("error 3");
					console.log(error);
				    $.LoadingOverlay("hide");
				  });
			}
			// else{
			// 	setTimeout(() => {
			//         loadManualEvents(speakerId);
			// 		pull_speaker_opp_linking(speakerId, 1);
			//     }, 1500);
			// }
		}

		$(document).on('click', '.ReloadPage', function () {
			refresh_widget();
		});

		function refresh_widget() {
			$(".msg_div").html('<span class="text-success">Refreshing...</span>');
			// cache.delete();
			// $('html[manifest=saveappoffline.appcache]').attr('content', '');
			//window.location.reload(true);
			loadCalendar();
		}

		// close the widget
		function close_widget() {
			// Close Widget Popup
			// ZOHO.CRM.UI.Popup.close().then(function(data){});
			ZOHO.CRM.UI.Popup.closeReload().then(function (data) { });
		}

		//Allow numeric with decimal
		$(document).on("keypress keyup blur", ".allownumericwithdecimal", function (event) {
			$(this).val($(this).val().replace(/[^0-9\.]/g, ''));
			if ((event.which != 46 || $(this).val().indexOf('.') != -1) && (event.which < 48 || event.which > 57)) {
				event.preventDefault();
			}
		});

		//Allow numeric without decimal
		$(document).on("keypress keyup blur", ".allownumericwithoutdecimal", function (event) {
			$(this).val($(this).val().replace(/[^0-9]/g, ""));
			if ((event.which < 48 || event.which > 57)) {
				event.preventDefault();
			}
		});
		//End











		var timer, delay = 500;
		// dropdown select search
		$(document).on('keyup', '.dropdownsearch', function () {
			var value = $(this).val();
			var $parent = $(this).closest('.dropdown');
			clearTimeout(timer);
			timer = setTimeout(function () {
				search_here(value, $parent);
			}, delay);
		});

		function search_here(value, $parent) {
			var page = 1;
			var rowID = $parent.data('rid');

			var selected_id = $parent.find(".selectedItem").val();
			var selected_name = $parent.find(".selectedItem").data("text");
			var is_selected = "";

			if (value.length >= 3) {
				// var jobdata = {"id": $parent.find(".selectedItem").val(), "name" : $parent.find(".selectedItem").data("text")};

				ZOHO.CRM.API.searchRecord({ Entity: "Jobs", sort_order: "desc", sort_by: "Created_Time", Type: "criteria", Query: "(Name:starts_with:" + value + ")", per_page: 200, page: page })
					.then(function (response) {
						if (response.data) {
							push_to_option(response, selected_id, $parent);
						} else {
							$('ul li:not(.searchInput)', $parent).remove();
							if (!$('.noresults', $parent).length) {
								$('ul', $parent).append('<li class="noresults">No results found</li>');
							}
						}
					});
			}

			if (value.length == 0) {
				ZOHO.CRM.API.getAllRecords({ Entity: "Jobs", sort_order: "desc", sort_by: "Created_Time", per_page: 200, page: page })
					.then(function (response) {
						if (response.data) {
							push_to_option(response, selected_id, $parent);
						} else {
							$('ul li:not(.searchInput)', $parent).remove();
							if (!$('.noresults', $parent).length) {
								$('ul', $parent).append('<li class="noresults">No results found</li>');
							}
						}
					});
			}
		}

		function push_to_option(response, selected_id, $parent) {
			$('ul li:not(.searchInput)', $parent).remove();
			response.data.forEach(function (item) {

				var Job_Id = (item.id != null) ? item.id : '';
				is_selected = (selected_id == Job_Id) ? "selected" : "";

				var Job_Name = (item.Name != null) ? item.Name + "<br>" : '';
				var Job_Type = (item.Job_Type != null) ? "<strong>Type:</strong> " + item.Job_Type + "<br>" : '';
				var Job_Status = (item.Job_Status != null) ? "<strong>Status:</strong> " + item.Job_Status + "<br>" : '';
				var Completion_Date = (item.Completion_Date != null) ? "<strong>Date:</strong> " + item.Completion_Date + "<br>" : '';
				var Description = (item.Description != null) ? item.Description : '';
				var Job_Full_Name = Job_Name + Job_Type + Job_Status + Completion_Date;


				var tootltip = '<img src="images/info-circle-fill.png" class="pt5" data-toggle="tooltip" data-placement="top" title="' + Description + '" width="18">';

				$('ul', $parent).append('<li data-id="' + Job_Id + '" data-text="' + Job_Full_Name + '" class="' + is_selected + '">' + Job_Full_Name + tootltip + '</li>');
			});

			if (response.length == 0) {
				if (!$('.noresults', $parent).length) {
					$('ul', $parent).append('<li class="noresults">No results found</li>');
				}
			} else {
				$('.noresults', $parent).remove();
			}
		}

		$(document).on('click', '.dropdown button', function () {
			$('.dropdown ul').hide();
			$(this).siblings('ul').show();
			$(this).siblings('ul').children('.searchInput').children('input').focus();

			var winH = $(window).height();
			var eleTop = $(this).offset().top;
			var eleOwn = $(this).outerHeight(true);
			var actualBottom = winH - (eleTop + eleOwn);
			$(this).siblings('ul').css({ "height": actualBottom + "px" });
		})

		$(document).on('click', '.dropdown ul li:not(.searchInput)', function () {
			var line_text = $(this).html();
			$(this).parent('ul').siblings('button').html(line_text);
			$(this).parent('ul').hide();
			$(this).parent('ul').find('.dropdownsearch').val('');
			$(this).parent('ul').find('li').removeClass('selected');
			$(this).closest('.customDropdown').find('.selectedItem').val($(this).data('id'));
			$(this).addClass('selected');

		});

		$(document).on('click', 'html', function (e) {
			if ($(e.target).parents('.dropdown').length == 0 && $(e.target).siblings('.dropdown').length == 0 && $(e.target).children('.dropdown').length == 0) {
				if ($(".dropdown ul").is(":visible")) {
					$('.dropdown ul').hide();
					$('.dropdownsearch').val('').keyup();
				}
			}
		});

		//enable tooltip
		$(function () {
			$('[data-toggle="tooltip"]').tooltip();
			// $(".fieldDate").datepicker({
			// 	dateFormat: 'dd-mm-yy',
			// 	changeMonth: true,
			// 	changeYear: true
			// });
			$('.fieldDate').datetimepicker({
				timepicker: false,
				format: 'm-d-Y',
				timepickerScrollbar: false,
				scrollInput: false,
				scrollMonth: false
				//formatTime: "h:i a",
			});
			$("#date_months").datepicker({
				dateFormat: 'MM yy',
				changeMonth: true,
				changeYear: true,
				onClose: function (dateText, inst) {
					$(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
				}
			});
		});


	})
	/*
	 * initialize the widget.
	 */
	ZOHO.embeddedApp.init();

};