
function initializeWidget() {
	/*
	 * Subscribe to the EmbeddedApp onPageLoad event before initializing the widget 
	 * https://www.zoho.com/crm/developer/docs/javascript-sdk/sample-codes.html
	 * https://help.zwidgets.com/help/latest/index.html
	 */
	ZOHO.embeddedApp.on("PageLoad", function (data) {
		// moment.tz.setDefault("Australia/Melbourne");

		var record_id = "";
		var ajaxRootUrl = "https://aucrm.authorsunbound.com/spk_v2/manualEventController/manualEventHandler";
		var dataURL = "https://aucrm.authorsunbound.com/spk_v2/DealController/";
		var speakerId = "";
		var calendarEl;
		var calendar;
		var calInitialDate = moment().format("YYYY-MM-DD");
		var timeZoneSettings = "+10:00";
		var timeZoneCountry = "Australia/Melbourne";
		var loadedView = '';

		function load_all_crm_event(skip = 0) {

			$.ajax({
				type: "POST",
				enctype: 'multipart/form-data',
				url: dataURL+"getAllDealsWhereEventDateIsNotNull",
				data: {actfor: "nothing"},
				cache: false,
				timeout: 800000,
				dataType: "json",
				success: function (data) {
					if (data) {
						//$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
						$.LoadingOverlay("show");
						finalData = data;
						prepareRelatedOpportunities(finalData);
					}
				},
				error: function (e) {
					console.log("ERROR : ", e);
				}
			});
		}

		ZOHO.CRM.UI.Resize({ height: "700", width: "2000" }).then(function (data) {
			// console.log(data);
		});

		// initialize Calendar
		calendarEl = document.getElementById('deal_calendar_main');

		if (data && data.Entity) {
			record_id = data.EntityId;
			load_initial_data(record_id, 1);
			load_all_authors();
		}
		// console.log(data);

		function initializePlugin() {
			$("[data-toggle='popover']").popover();
			$("[data-toggle='tooltip']").tooltip();
			// $(".fieldDate").datepicker({
			// 	dateFormat: 'dd-mm-yy',
			// 	changeMonth: true,
			// 	changeYear: true
			// });
			$('.fieldDate').datetimepicker({
				timepicker: false,
				format: 'm-d-Y',
				timepickerScrollbar: false,
				scrollInput: false,
				scrollMonth: false
				//formatTime: "h:i a",
			});
			$("#date_months").datepicker({
				dateFormat: 'MM yy',
				changeMonth: true,
				changeYear: true,
				onClose: function (dateText, inst) {
					$(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
				}
			});
		}

		function load_all_authors(pagesetup = 1){

			$.ajax({
				type: "POST",
				enctype: 'multipart/form-data',
				url: dataURL+"getAllAuthors",
				data: {actfor: "nothing"},
				cache: false,
				timeout: 800000,
				dataType: "json",
				success: function (data) {
					if (data) {
						finalData = data;
						jQuery.each(finalData, function (i, item) {
							let Shortlisted_Speaker = (item.Name) ? item.Name : "";
							let Shortlisted_Speaker_Id = (item.module_id) ? item.module_id : "";
							$("#selectField").append("<option value='"+Shortlisted_Speaker_Id+"'>"+Shortlisted_Speaker+"</option>");
						});
					}
				},
				error: function (e) {
					console.log("ERROR : ", e);
				}
			});
		}

		//Start edit event name

		$(document).on("click",".edit-event-name",function(){

			$(".event-name-box").hide();
			$(".event-name-for-edit").show();

		});

		$(document).on("click",".submit-event-name",function(){

			var thisPointer = $(this);
			$.ajax({
				type: "POST",
				enctype: 'multipart/form-data',
				url: ajaxRootUrl,
				data: {actfor: "updateEvent", title: $(this).closest("div").find('.edit-event-name-value').val(), id: $(this).closest(".event-detail").find('.event-id-for-edit').val()},
				cache: false,
				timeout: 800000,
				dataType: "json",
				success: function (data) {
					// $("#output").text(data);
					console.log("SUCCESS : ", data);
					// $("#btnSubmit").prop("disabled", false);
					if (data.status == "success") {
						console.log(thisPointer.closest('div').find(".edit-event-name-value").val());
						$("#actionViewEventModalManual .event-title").html(thisPointer.closest('div').find(".edit-event-name-value").val());
						$(".event-name-box").show();
		    			$(".event-name-for-edit").hide();
						calendar.removeAllEvents();
						//$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
						loadCalendar();
					}
				},
				error: function (e) {
					console.log("ERROR : ", e);
				}
			});

		});

		//End edit event name

		$(document).on("click",".edit-start-date",function(){

			$(".start-date-box").hide();
			$(".start-date-box-for-edit").show();

		});

		$(document).on("click",".edit-end-date",function(){

			$(".end-date-box").hide();
			$(".end-date-box-for-edit").show();

		});

		$('#actionViewEventModalManual').on('hidden.bs.modal', function () {
		    $(".start-date-box").show();
		    $(".start-date-box-for-edit").hide();
		    $(".end-date-box").show();
		    $(".end-date-box-for-edit").hide();
		    $(".event-edit-original").show();
		    $(".edit-description").show();
		    $(".ev-description-edit").hide();
		    $(".edit-description-ok").hide();
		    $(".event-note-content-original").show();
		    $(".event-note-content-for-edit").hide();
		});

		$(document).on("click",".submit-start-date",function(){

			var thisPointer = $(this);
			$.ajax({
				type: "POST",
				enctype: 'multipart/form-data',
				url: ajaxRootUrl,
				data: {actfor: "updateEvent", start: moment($(this).closest("div").find('.edit-start-date-value').val(), 'MM-DD-YYYY HH:mm').format("YYYY-MM-DD HH:mm"), id: $(this).closest(".event-detail").find('.event-id-for-edit').val()},
				cache: false,
				timeout: 800000,
				dataType: "json",
				success: function (data) {
					// $("#output").text(data);
					console.log("SUCCESS : ", data);
					// $("#btnSubmit").prop("disabled", false);
					if (data.status == "success") {
						console.log(thisPointer.closest('div').find(".edit-start-date-value").val());
						$("#actionViewEventModalManual .event-date").html(moment(thisPointer.closest('div').find(".edit-start-date-value").val()).format("MM-DD-YYYY"));
						$(".start-date-box").show();
						$(".start-date-box-for-edit").hide();
						calendar.removeAllEvents();
						//$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
						loadCalendar();
					}
				},
				error: function (e) {
					console.log("ERROR : ", e);
				}
			});

		});

		$(document).on("click",".submit-end-date",function(){

			var thisPointer = $(this);
			$.ajax({
				type: "POST",
				enctype: 'multipart/form-data',
				url: ajaxRootUrl,
				data: {actfor: "updateEvent", end: moment($(this).closest("div").find('.edit-end-date-value').val(), 'MM-DD-YYYY HH:mm').format("YYYY-MM-DD HH:mm"), id: $(this).closest(".event-detail").find('.event-id-for-edit').val()},
				cache: false,
				timeout: 800000,
				dataType: "json",
				success: function (data) {
					// $("#output").text(data);
					console.log("SUCCESS : ", data);
					// $("#btnSubmit").prop("disabled", false);
					if (data.status == "success") {
						$("#actionViewEventModalManual .event-last-day").html(moment(thisPointer.closest('div').find(".edit-end-date-value").val()).format("MM-DD-YYYY"));
						$(".end-date-box").show();
						$(".end-date-box-for-edit").hide();
						calendar.removeAllEvents();
						//$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
						loadCalendar();
					}
				},
				error: function (e) {
					console.log("ERROR : ", e);
				}
			});

		});

		$(document).on("click",".edit-description",function(){

			$(".event-edit-original").hide();
			$(".ev-description-edit").show();
			$(".edit-description-ok").show();

		});

		$(document).on("click",".edit-description-ok",function(){

			var thisPointer = $(this);
			$.ajax({
				type: "POST",
				enctype: 'multipart/form-data',
				url: ajaxRootUrl,
				data: {actfor: "updateEvent", description: $(this).closest(".event-detail").find('.ev-description-edit').val(), id: $(this).closest(".event-detail").find('.event-id-for-edit').val()},
				cache: false,
				timeout: 800000,
				dataType: "json",
				success: function (data) {
					// $("#output").text(data);
					console.log("SUCCESS : ", data);
					// $("#btnSubmit").prop("disabled", false);
					if (data.status == "success") {
						$("#actionViewEventModalManual .event-description-manual").html(thisPointer.closest(".event-detail").find('.ev-description-edit').val());
						$(".event-edit-original").show();
						$(".edit-description").show();
						$(".ev-description-edit").hide();
						$(".edit-description-ok").hide();
						calendar.removeAllEvents();
						//$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
						loadCalendar();
					}
				},
				error: function (e) {
					console.log("ERROR : ", e);
				}
			});

		});

		//start edit note

		$(document).on("click",".edit-note",function(){

			$(this).closest(".note-wrapper").find(".event-note-content-original").hide();
			$(this).closest(".note-wrapper").find(".event-note-content-for-edit").show();

		});

		$(document).on("click",".edit-note-done",function(){

			var thisPointer = $(this);
			$.ajax({
				type: "POST",
				enctype: 'multipart/form-data',
				url: ajaxRootUrl,
				data: {actfor: "updateNote", notes: $(this).closest(".note-wrapper").find('textarea').val(), id: $(this).data("noteid")},
				cache: false,
				timeout: 800000,
				dataType: "json",
				success: function (data) {
					// $("#output").text(data);
					console.log("SUCCESS : ", data);
					// $("#btnSubmit").prop("disabled", false);
					if (data.status == "success") {
						thisPointer.closest(".note-wrapper").find(".main-note-content").html(thisPointer.closest(".note-wrapper").find('textarea').val());
						thisPointer.closest(".note-wrapper").find(".event-note-content-original").show();
						thisPointer.closest(".note-wrapper").find(".event-note-content-for-edit").hide();
						//calendar.removeAllEvents();
						//$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
						//loadCalendar();
					}
				},
				error: function (e) {
					console.log("ERROR : ", e);
				}
			});

		});

		$(document).on("click",".edit-crm-note-done",function(){

			thisPointer = $(this);

			var config={
			  Entity:"Notes",
			  APIData:{
			        "id": $(this).data("noteid"),
			        "Note_Content": $(this).closest(".note-wrapper").find('textarea').val()
			  }
			}
			console.log( config );
			ZOHO.CRM.API.updateRecord(config)
			.then(function(data){
				console.log("Note Update Info");
			    console.log(data);
			    thisPointer.closest(".note-wrapper").find(".main-note-content").html(thisPointer.closest(".note-wrapper").find('textarea').val());
			    thisPointer.closest(".note-wrapper").find(".event-note-content-original").show();
			    thisPointer.closest(".note-wrapper").find(".event-note-content-for-edit").hide();
			});

		});

		$(document).on('click', '.delete-note', function (e) {
			//$("#actionViewEventModalManual").modal('hide');
			var note_id = $(this).data("noteid");
			var thisPointer = $(this);

			$('<div></div>').appendTo('body').html('<div><h6>Are you sure?</h6></div>').dialog({
				modal: true,
				title: 'Delete',
				zIndex: 10000,
				autoOpen: true,
				width: '500px',
				resizable: false,
				buttons: {
					Yes: function () {
						// $(obj).removeAttr('onclick');                                
						// $(obj).parents('.Parent').remove();
						// $('body').append('<h1>Confirm Dialog Result: <i>Yes</i></h1>');
						const _thisDialog = $(this);
						var fd = new FormData();
						fd.append('actfor', "deletenote");
						fd.append('note_id', note_id);
						$.ajax({
							type: "POST",
							enctype: 'multipart/form-data',
							url: ajaxRootUrl,
							data: fd,
							processData: false,
							contentType: false,
							cache: false,
							timeout: 800000,
							dataType: "json",
							success: function (data) {
								console.log("SUCCESS : ", data);
								_thisDialog.dialog("close");
								if (data.status == "success") {
									// loadCalendar([]);
									thisPointer.closest(".note-wrapper").remove();
									//calendar.removeAllEvents();
									//$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
									//loadCalendar();
								}
							},
							error: function (e) {
								console.log("ERROR : ", e);
								_thisDialog.dialog("close");
							}
						});

						// $(this).dialog("close");
					},
					No: function () {
						// $('body').append('<h1>Confirm Dialog Result: <i>No</i></h1>');
						$(this).dialog("close");
					}
				},
				close: function (event, ui) {
					$(this).remove();
				}
			});

			return false;
		});

		$(document).on('click', '.delete-crm-note', function (e) {
			//$("#actionViewEventModal").modal('hide');
			var note_id = $(this).data("noteid");
			var thisPointer = $(this);

			$('<div></div>').appendTo('body').html('<div><h6>Are you sure?</h6></div>').dialog({
				modal: true,
				title: 'Delete',
				zIndex: 10000,
				autoOpen: true,
				width: '500px',
				resizable: false,
				buttons: {
					Yes: function () {
						const _thisDialog = $(this);
						ZOHO.CRM.API.deleteRecord({Entity:"Notes",RecordID: note_id})
						.then(function(data){
							console.log("Note delete info");
						    console.log(data);
						    _thisDialog.dialog("close");
						    thisPointer.closest(".note-wrapper").remove();
						})
					},
					No: function () {
						// $('body').append('<h1>Confirm Dialog Result: <i>No</i></h1>');
						$(this).dialog("close");
					}
				},
				close: function (event, ui) {
					$(this).remove();
				}
			});

			return false;
		});

		//end edit note

		async function load_initial_data(frecord_id = record_id, page = 1) {
			record_id = frecord_id;
			var dealData = await fetch_deal_details_by_id(record_id);
			if( dealData.Event_Date != null ){
				calInitialDate = dealData.Event_Date;
			}
			//console.log(dealData.Event_Date);
			$.ajax({
				type: "POST",
				enctype: 'multipart/form-data',
				url: dataURL+"getAllSuggestedAuthorsOfTheDealWithDealInfo",
				data: {dealId: record_id},
				cache: false,
				timeout: 800000,
				dataType: "json",
				success: function (data) {
					activeLinkFound = false;

					if (data[0].Confirmed_Author !== null) {
						speakerId = data[0].Confirmed_Author_ID;
						var activeLinkFound = true;
						$(".deal_speaker").append('<li class="speaker-name custom-list-group-item active" data-speakerid="'+data[0].Confirmed_Author_ID+'"><b>' + data[0].Confirmed_Author + '</b></li>');
					}

			    	finalData = data;
			    	//$(".deal_speaker").empty();
			    	//$(".deal_speaker").append('<option value="">-None-</option>');
			    	if (finalData.length > 0) {
			    		jQuery.each( finalData, function ( i, item ) {
			    			console.log("item check");
			    			console.log(item);
			    			let activeOrNot = '';
			    			// if( i == 0 && activeLinkFound == false ){
			    			// 	activeOrNot = 'active';
			    			// 	speakerId = finalData[0].Suggested_Authors.id;
			    			// }
			    			let Shortlisted_Speaker = (item.Author_Name) ? item.Author_Name : "";
			    			let Shortlisted_Speaker_Id = (item.Author_Name) ? item.Suggested_Authors_ID : "";
			    			//$(".deal_speaker").append('<option value="' + Shortlisted_Speaker_Id + '">' + Shortlisted_Speaker + '</option>');
			    			if( speakerId != Shortlisted_Speaker_Id ){
			    				$(".deal_speaker").append('<li class="speaker-name custom-list-group-item" data-speakerid="'+Shortlisted_Speaker_Id+'"><b>' + Shortlisted_Speaker + '</b></li>');
			    			}
			    		} );
			    		//$(".deal_speaker").val(speakerId);
			    		//pull_speaker_opp_linking(speakerId);
			    		//loadManualEvents(speakerId);
			    	}

    			    if( activeLinkFound == false ){
    			    	//activeOrNot = 'active';
    			    	//speakerId = finalData[0].Suggested_Authors_ID;
    	    		    // Get the original list items
    	    	        const originalList = $(".deal_speaker li");

    	    	        // Clone the original list items and sort them alphabetically
    	    	        const sortedItems = originalList.clone().sort(function (a, b) {
    	    	            return $(a).text().localeCompare($(b).text());
    	    	        });

    	    	        // Clear the original list
    	    	        originalList.remove();

    	    	        // Append the sorted items back to the original list
    	    	        sortedItems.appendTo(".deal_speaker");

    	    	        $(".deal_speaker li:first").addClass("active");

    	    	        speakerId = $(".deal_speaker li:first").data("speakerid");

    	    	        console.log("The Speaker ID");
    	    	        console.log( speakerId );
    			    }

    			    loadCalendar();
    			    initializePlugin();
				},
				error: function (e) {
					console.log("ERROR : ", e);
				}
			});
		}

		/*$(document).on('change', '.deal_speaker', function (e) {
			speakerId = $(this).val();
			if (speakerId != "") {
				$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
				// loadCalendar([]);
				calendar.removeAllEvents();
				pull_speaker_opp_linking(speakerId);
				//loadManualEvents(speakerId);
			} else {
				// loadCalendar([]);
				calendar.removeAllEvents();
			}
		});*/

		$(document).on('click', '.speaker-name', function (e) {
			$.LoadingOverlay("show");
			speakerId = $(this).data("speakerid");
			$(".speaker-name").removeClass("active");
			$(this).addClass("active");
			//$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
			calendar.removeAllEvents();
			if (speakerId != "" && speakerId != "all") {
				// loadCalendar([]);
				pull_speaker_opp_linking(speakerId);
				pull_speaker_not_confirmed(speakerId);
				loadManualEvents(speakerId);
			} else {
				// loadCalendar([]);
				load_all_event();
				load_all_crm_event();
			}
		});

		function pull_speaker_opp_linking(speakerId, page = 1) {

			return new Promise((resolve, reject) => {

				$.ajax({
					type: 'POST',
					url: dataURL+"getConfirmedDealByAuthorId",
					data: {
						authorId: speakerId,
						selecteddate: calInitialDate,
						view: loadedView
					},
					dataType: "json",
					success: async function (data) {
						finalData = data;
						//$.LoadingOverlay("show");
						console.log("check resolve");
						prepareRelatedOpportunities(finalData).then(function(){resolve();});
					},
					error: function (error) {
						console.log(error);
						resolve();
					}
				});
			});
		}

		async function pull_speaker_not_confirmed(speakerId, page = 1) {

			//$.LoadingOverlay("show");

			return new Promise(async (resolve, reject) => {

				$.ajax({
					type: 'POST',
					url: dataURL+"getAllDealsWhereThisSpeakerAsSuggested",
					data: {
						authorId: speakerId,
						selecteddate: calInitialDate,
						view: loadedView
					},
					dataType: "json",
					success: async function (data) {
						if (data) {
						    const finalData = data;
						    // console.log("shoukhin");
						    // console.log(finalData);

						    // Uncomment the lines below if you want to use the data inside the jQuery.each loop
						    //$(".deal_speaker").empty();
						    //$(".deal_speaker").append('<option value="">-None-</option>');
						    let allFoundedDeals = [];
						    // Using regular for loop with async/await
						    for (let i = 0; i < finalData.length; i++) {
						    	// Process each item in the loop
						    	const item = finalData[i];
						    	//let dealInfo = await fetch_deal_details_by_id(item.Suggested_Deals_ID);
						    	if( item.Confirmed_Author_ID == null ){
						    		allFoundedDeals.push(item);
						    	}
						    }

						    // if (allFoundedDeals.length === 0) {
						    // 	$.LoadingOverlay("hide");
						    // }else{
						    // 	prepareRelatedOpportunities(allFoundedDeals);
						    // }

						    prepareRelatedOpportunities(allFoundedDeals).then(function(){resolve();}).catch(error => {
								console.log("error 4");
								console.log(error);
								resolve();
							});

						    // resolve();
						}
						else{
						    resolve();
						    //$.LoadingOverlay("hide");
						}
					},
					error: function (error) {
						console.log(error);
					}
				});
			});

		}

		async function fetch_deal_details_by_id(deal_id) {

			return new Promise(async (resolve, reject) => {

				$.ajax({
					type: 'POST',
					url: dataURL+"getDealInfoById",
					data: {
						dealId: deal_id
					},
					dataType: "json",
					success: async function (data) {
						resolve(data);
					},
					error: function (error) {
						console.log(error);
						resolve();
					}
				});

			});
		}

		function loadCalendar(calEvents = []) {

			calendar = new FullCalendar.Calendar(calendarEl, {
				initialView: 'dayGridMonth',
				initialDate: calInitialDate,
				//aspectRatio: 2.7, //height of row
				selectable: true,
				events: calEvents,
				displayEventTime: false,
				customButtons: {
			      myCustomButton: {
			        text: 'Refresh',
			        click: function() {
			          // Handle button click event
			          refresh_widget();
			        }
			      }
			    },
			    /*buttonText: {
			        today: 'Today', // Custom text for the 'today' button
			        month: 'Month', // Custom text for the 'month' button
			        week: 'Week',   // Custom text for the 'week' button
			        day: 'Day',     // Custom text for the 'day' button
			        list: 'List',   // Custom text for the 'list' button
			        // Add any other custom button texts you want to change
			    },*/
			    buttonText: {
			        today: 'Today', // Custom text for the 'today' button
			        month: 'Month', // Custom text for the 'month' button
			        //week: 'Week',   // Custom text for the 'week' button
			        day: 'Day',     // Custom text for the 'day' button
			        //list: 'Week',   // Custom text for the 'list' button
			        listMonth: 'Month',   // Custom text for the 'list' button
			        listWeek: 'Week',   // Custom text for the 'list' button
			        listYear: 'Year'   // Custom text for the 'list' button
			        // Add any other custom button texts you want to change
			    },
			    viewClassNames: function(obj) {
			    	loadedView = obj.view.type;
			    	if(obj.view.type == "listMonth" || obj.view.type == "listYear"){
			    		var add_button = '<div class="fc-toolbar fc-toolbar-ltr custom-month-selector" style="margin-bottom:11px">\
			    			<div class="fc-toolbar-chunk">\
								<div class="fc-button-group">\
									<button type="button" title="Month Name" aria-pressed="false" class="fc-monthName-button fc-button fc-button-primary" data-month="01">Jan</button>\
									<button type="button" title="Month Name" aria-pressed="false" class="fc-monthName-button fc-button fc-button-primary" data-month="02">Feb</button>\
									<button type="button" title="Month Name" aria-pressed="false" class="fc-monthName-button fc-button fc-button-primary" data-month="03">Mar</button>\
									<button type="button" title="Month Name" aria-pressed="false" class="fc-monthName-button fc-button fc-button-primary" data-month="04">Apr</button>\
									<button type="button" title="Month Name" aria-pressed="false" class="fc-monthName-button fc-button fc-button-primary" data-month="05">May</button>\
									<button type="button" title="Month Name" aria-pressed="false" class="fc-monthName-button fc-button fc-button-primary" data-month="06">Jun</button>\
									<button type="button" title="Month Name" aria-pressed="false" class="fc-monthName-button fc-button fc-button-primary" data-month="07">Jul</button>\
									<button type="button" title="Month Name" aria-pressed="false" class="fc-monthName-button fc-button fc-button-primary" data-month="08">Aug</button>\
									<button type="button" title="Month Name" aria-pressed="false" class="fc-monthName-button fc-button fc-button-primary" data-month="09">Sep</button>\
									<button type="button" title="Month Name" aria-pressed="false" class="fc-monthName-button fc-button fc-button-primary" data-month="10">Oct</button>\
									<button type="button" title="Month Name" aria-pressed="false" class="fc-monthName-button fc-button fc-button-primary" data-month="11">Nov</button>\
									<button type="button" title="Month Name" aria-pressed="false" class="fc-monthName-button fc-button fc-button-primary" data-month="12">Dec</button>\
								</div>\
							</div>\
							<div class="fc-toolbar-chunk"></div>\
							<div class="fc-toolbar-chunk">\
								<select id="yearSelect" class="form-control"></select>\
							</div>\
						</div>';
						$(".custom-month-selector").remove(); 
			    		$(".fc-header-toolbar").after(add_button);
			    		var currentYear = new Date().getFullYear();
			    		var dateParts = calInitialDate.split('-');
			    		var startYear = 2000;
			    		var selectYear = $('#yearSelect');
			    		for (var year = currentYear+10; year >= startYear; year--) {
    		                var option = $('<option>', {
    		                    value: year,
    		                    text: year
    		                });
    		                if (year == dateParts[0]) {
	                            option.attr("selected", "selected");
	                        }
    		                selectYear.append(option);
    		            }

    		            //var currentDate = new Date();
    		            //var currentMonth = (currentDate.getMonth() + 1).toString().padStart(2, '0');
    		            var numericMonth = dateParts[1];

    		            console.log("numericMonth");
    		            console.log(numericMonth);

    		            var monthButtons = $('.fc-monthName-button');
    		            var initialSelectedMonth = $('.fc-monthName-button[data-month="'+numericMonth+'"]');
    		            initialSelectedMonth.addClass("fc-button-active");
    		            initialSelectedMonth.attr("aria-pressed",true);

    		            $('.fc-monthName-button').on('click', function () {
    		            	monthButtons.removeClass("fc-button-active");
    		            	monthButtons.attr("aria-pressed",false);
    		            	var selectedMonth = $(this);
    		            	selectedMonth.addClass("fc-button-active");
    		            	selectedMonth.attr("aria-pressed",true);
    		            	var formattedDate = $(this).data("month")+' '+$("#yearSelect").val();
    		            	const selectedDate = moment(formattedDate, 'MM YYYY').format("YYYY-MM-01");
    		            	calInitialDate = selectedDate;
    		            	calendar.gotoDate(selectedDate);
    		            });

    		            $(document).on('change', '#yearSelect', function () {
    		            	var selectedMonth = $('.fc-monthName-button[aria-pressed="true"]');
    		            	var formattedDate = $(selectedMonth).data("month")+' '+$("#yearSelect").val();
    		            	const selectedDate = moment(formattedDate, 'MM YYYY').format("YYYY-MM-01");
    		            	calendar.gotoDate(selectedDate);
    		            });
			    	}else{
			    		if(obj.view.type != "dayGridMonth"){
			    			$("#date_months").datepicker("destroy");
			    			$("#date_months").datepicker({
			    				dateFormat: 'MM yy',
			    				changeMonth: true,
			    				changeYear: true,
			    				onClose: function (dateText, inst) {
			    					var selectedDate = inst.selectedYear+'-'+(inst.selectedMonth+1)+'-'+inst.selectedDay;
			    					var momentDate = moment(selectedDate, 'YYYY-M-D').format('YYYY-MM-DD');
			    					$(this).datepicker('option', 'defaultDate', new Date(inst.selectedYear, inst.selectedMonth, inst.selectedDay));
			    					$(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, inst.selectedDay));
			    					calendar.gotoDate( momentDate );
			    				}
			    			});
			    			calInitialDate = moment().format("YYYY-MM-DD");
			    			calendar.gotoDate(calInitialDate);
			    		}
			    		$(".custom-month-selector").remove();
			    	}
			    },
			    headerToolbar: {
			      //left: 'dayGridMonth,timeGridWeek,timeGridDay,listWeek',
			      //left: 'listMonth,listWeek,listYear,customListYear',
			      left: 'dayGridMonth,listWeek,listYear',
			      //center: 'title',
			      //right: 'prev,next today myCustomButton' // Add the custom button to the header
			      right: 'today myCustomButton' // Add the custom button to the header
			    },
			    /*headerToolbar: {
			      left: 'dayGridMonth,timeGridWeek,timeGridDay,listWeek',
			      //center: 'title',
			      right: 'prev,next today myCustomButton' // Add the custom button to the header
			    },*/
			    eventDidMount: function(info) {
		          // Add ribbon for one-day events
		          if (info.event.end - info.event.start <= 24 * 60 * 60 * 1000) {
		          	var dotElement = info.el.querySelector('.fc-daygrid-event-dot');
		          	if( dotElement != null ){
		          		dotElement.style.display = 'none';
		          	}
		            /*var titleElement = info.el.querySelector('.fc-event-title');
		            titleElement.style.backgroundColor = 'yellow';*/
		          }

		          // Select the element containing the text
	        	  	var textContainer = $('.fc-listYear-view .fc-list-day .fc-list-day-text:first');

	        	  	// Get the text from the element
	        	  	var text = textContainer.text();

	        	  	// Split the text by the first space
	        	  	var parts = text.split(' ');

	        	  	// Take the first part (before the first space)
	        	  	var newText = parts[0];

	        	  	// Update the text in the element
	        	  	textContainer.text(newText);

	        	  	var isIncludeRow = true;

	        	  	$('.fc-listMonth-view table.fc-list-table tr, .fc-listWeek-view table.fc-list-table tr').each(function() {
	        	  	  var $row = $(this);

	        	  	  if ($row.hasClass('fc-list-day')) {
	        	  	    isIncludeRow = true; // Reset the flag for include rows after not-include row
	        	  	  } else {
	        	  	    $row.css('background-color', isIncludeRow ? 'white' : '#F1F1F1');
	        	  	    isIncludeRow = !isIncludeRow;
	        	  	  }
	        	  	});

	        	  	var isIncludeRowForYear = true;
	        	  	$('.fc-listYear-view table.fc-list-table tr').each(function() {
	        	  	  var $row = $(this);

	        	  	  if ($row.hasClass('fc-list-day')) {
	        	  	    //isIncludeRow = true; // Reset the flag for include rows after not-include row
	        	  	    return true;
	        	  	  } else {
	        	  	    $row.css('background-color', isIncludeRowForYear ? '#F1F1F1':'white');
	        	  	    isIncludeRowForYear = !isIncludeRowForYear;
	        	  	  }
	        	  	});
		        },
		        eventContent: function(info){
		        	// Select the element containing the text
	        	  	var textContainer = $('.fc-listYear-view .fc-list-day .fc-list-day-text:first');

	        	  	// Get the text from the element
	        	  	var text = textContainer.text();

	        	  	// Split the text by the first space
	        	  	var parts = text.split(' ');

	        	  	// Take the first part (before the first space)
	        	  	var newText = parts[0];

	        	  	// Update the text in the element
	        	  	textContainer.text(newText);
		        },
				eventClick: function (info) {
					console.log(info.event);
					let evSt = (info.event.start != "" && info.event.start != null) ? moment(info.event.start).format("MM-DD-YYYY") : "";
					let evEd = (info.event.end != "" && info.event.end != null) ? moment(info.event.end).format("MM-DD-YYYY") : "";
					if (info.event.extendedProps.type == "crm") {

						$("#actionViewEventModal .event-title").html(info.event.title);
						$("#actionViewEventModal .event-deal").html('<a target="_blank" href="https://crm.zoho.com/crm/org812409302/tab/Deals/' + info.event.extendedProps.itemInfo.module_id + '">' + info.event.extendedProps.itemInfo.Deal_Name + '</a>');
						$("#actionViewEventModal .event-confirmed-author").html("");
						if( info.event.extendedProps.itemInfo.Confirmed_Author != null ){

							if (info.event.extendedProps.itemInfo.Confirmed_Author === undefined) {
							    $("#actionViewEventModal .event-confirmed-author").html('<a target="_blank" href="https://crm.zoho.com/crm/org812409302/tab/CustomModule6/' + info.event.extendedProps.itemInfo.Confirmed_Author_ID + '">' + info.event.extendedProps.itemInfo.Confirmed_Author + '</a>');
							}else{
								$("#actionViewEventModal .event-confirmed-author").html('<a target="_blank" href="https://crm.zoho.com/crm/org812409302/tab/CustomModule6/' + info.event.extendedProps.itemInfo.Confirmed_Author_ID + '">' + info.event.extendedProps.itemInfo.Confirmed_Author + '</a>');
							}
							
						}
						$(".suggested-authors").html("");

						$.ajax({
							type: 'POST',
							url: dataURL+"getAllSuggestedAuthorsOfTheDeal",
							data: {
								dealId: record_id
							},
							dataType: "json",
							success: function (data) {
								if (data) {
									finalData = data;
									//$(".deal_speaker").empty();
									//$(".deal_speaker").append('<option value="">-None-</option>');
									if (finalData.length > 0) {
										speakerId = finalData[0].Suggested_Authors_ID;
										jQuery.each(finalData, function (i, item) {
											let Shortlisted_Speaker = (item.Suggested_Authors) ? item.Suggested_Authors : "";
											let Shortlisted_Speaker_Id = (item.Suggested_Authors_ID) ? item.Suggested_Authors_ID : "";
											//$(".deal_speaker").append('<option value="' + Shortlisted_Speaker_Id + '">' + Shortlisted_Speaker + '</option>');
											$(".suggested-authors").append('<li><a target="_blank" href="https://crm.zoho.com/crm/org812409302/tab/CustomModule6/' + Shortlisted_Speaker_Id + '">' + Shortlisted_Speaker + '</a></li>');
										});
									}
								}
							},
							error: function (error) {
								console.log(error);
							}
						});
						// $("#actionViewEventModal .event-datetime").html(moment(info.event.start).format("LL") + " - " + moment(info.event.end).format("LL"));
						if( info.event.extendedProps.itemInfo.Account_Name != null ){
							$("#actionViewEventModal .event-account-name").html('<a target="_blank" href="https://crm.zoho.com/crm/org812409302/tab/Accounts/' + info.event.extendedProps.itemInfo.Account_Name_ID + '">' + info.event.extendedProps.itemInfo.Account_Name + '</a>');
						}
						//$("#actionViewEventModal .event-datetime").html(evSt + " - " + evEd);
						$("#actionViewEventModal .event-date").html(moment(info.event.extendedProps.itemInfo.Event_Date).format("MM-DD-YYYY"));
						$("#actionViewEventModal .event-last-day").html(moment(info.event.extendedProps.itemInfo.Last_Day_of_Event).format("MM-DD-YYYY"));
						$("#actionViewEventModal .event-format").html(info.event.extendedProps.itemInfo.Event_Medium);
						$("#actionViewEventModal .au-agent").html(info.event.extendedProps.itemInfo.AU_Agent);
						$("#actionViewEventModal .event-designer").html(info.event.extendedProps.itemInfo.Event_Designer);
						$("#actionViewEventModal .event-city").html(info.event.extendedProps.itemInfo.Event_City);
						$("#actionViewEventModal .event-state").html(info.event.extendedProps.itemInfo.Event_State);
						//$("#actionViewEventModal .event-type").html("Type: Deals");

						$("#actionViewEventModal .event-notes").html("");
						$("#actionViewEventModal .saveEventNote").data("moduleid", info.event.extendedProps.itemInfo.module_id);
						$("#actionViewEventModal .saveEventNote").data("module", "Deals");
						$("#actionViewEventModal").data("moduleid", info.event.extendedProps.itemInfo.module_id);
						$("#actionViewEventModal").data("module", "Authors");
						$("#actionViewEventModal").data("recurring", "");
						$("#actionViewEventModal").data("recparent", "");
						load_event_notes(info.event.extendedProps.itemInfo.module_id, "Deals");
						$("#actionViewEventModal .eventDelete").hide();
						$("#actionViewEventModal .eventDeleteRecur").hide();
						$("#actionViewEventModal").modal("show");
					} else {

						let evSt = (info.event.start != "" && info.event.start != null) ? moment(info.event.start).format("MM-DD-YYYY") : "";
						let evEd = (info.event.end != "" && info.event.end != null) ? moment(info.event.end).format("MM-DD-YYYY") : "";

						$.ajax({
							type: 'POST',
							url: dataURL+"getAuthorInfoById",
							data: {
								authorId: info.event.extendedProps.itemInfo.speaker_id
							},
							dataType: "json",
							success: function (data) {
								if (data) {
									$("#actionViewEventModalManual .event-link-author").html('<a target="_blank" href="https://crm.zoho.com/crm/org812409302/tab/CustomModule6/' + info.event.extendedProps.itemInfo.speaker_id + '">' + data.Name + '</a>');
						    		$("#actionViewEventModalManual .author-id-for-edit").val(info.event.extendedProps.itemInfo.speaker_id);
								}
							},
							error: function (error) {
								console.log(error);
							}
						});

						$("#actionViewEventModalManual .event-title").html(info.event.extendedProps.modalEventName);
						$("#actionViewEventModalManual .edit-event-name-value").val(info.event.extendedProps.modalEventName);
						$("#actionViewEventModalManual .event-description-manual").html(info.event.extendedProps.itemInfo.description);
						$("#actionViewEventModalManual .ev-description-edit").val(info.event.extendedProps.itemInfo.description);
						$("#actionViewEventModalManual .saveEventNote").data("moduleid", info.event.id);
						$("#actionViewEventModalManual .saveEventNote").data("module", "CustomEvent");
						$("#actionViewEventModalManual").data("moduleid", info.event.id);
						$("#actionViewEventModalManual").data("module", "CustomEvent");
						$("#actionViewEventModalManual .event-date").html(moment(info.event.extendedProps.itemInfo.start).format("MM-DD-YYYY"));
						$("#actionViewEventModalManual .edit-start-date-value").val(moment(info.event.extendedProps.itemInfo.start).format("MM-DD-YYYY"));
						$("#actionViewEventModalManual .event-last-day").html(moment(info.event.extendedProps.itemInfo.end).format("MM-DD-YYYY"));
						$("#actionViewEventModalManual .edit-end-date-value").val(moment(info.event.extendedProps.itemInfo.end).format("MM-DD-YYYY"));
						$("#actionViewEventModalManual .event-notes").html('');
						$("#actionViewEventModalManual .event-id-for-edit").val(info.event.id);
						$("#actionViewEventModalManual .show-custom-event-type").text(info.event.extendedProps.itemInfo.custom_event_type);
						load_manual_notes(info.event.id);
						$("#actionViewEventModalManual .eventDelete").show();

						$("#actionViewEventModalManual .eventDeleteRecur").hide();

						$("#actionViewEventModalManual").modal("show");
					}
				},
				select: function (info, jsEvent, view) {
					$("#actionEventModal").find(".evStartDate").val(moment(info.start).format("MM-DD-YYYY"));
					$("#actionEventModal").find(".evEndDate").val(moment(info.start).format("MM-DD-YYYY"));
					$("#actionEventModal").find("input[name=custom_event_type]").prop('checked', false);
					if( speakerId == "" || speakerId == "all" ){
						$("#selectField").val('');
					}else{
						$("#selectField").val(speakerId);
					}
					$("#actionEventModal").modal("show");
				},
				datesSet: function (info) {
					buildMonthList();
				},

			});
			calendar.render();

			initializePlugin();
		}

		function loadEventInCalendar(calEvents = [], isRemove = "") {
			// removeEvents = calendar.getEventSources();
			// removeEvents.forEach(event => {
			// 	console.log("event: ", event)
			// 	// event.remove();
			// });
			// calendar.removeAllEvents();
			return new Promise(async (resolve, reject) => {
				console.log("here I am");

				await Promise.all($.each(calEvents, function (key, item) {
					// calendar.removeEvents(item.id);
					// $('#speaker_calendar_main').fullCalendar('removeEvents', item.id);
					console.log(item);
					calendar.addEvent(item);
				}));

				resolve();
			});
		}

		function load_event_notes(module_id, module, page = 1) {
			ZOHO.CRM.API.getRelatedRecords({ Entity: module, RecordID: module_id, RelatedList: "Notes", page: page, per_page: 200 })
				.then(function (response) {
					console.log(response)
					if (response.data) {
						finalData = response.data;
						$.each(finalData, function (key, item) {
							//$("#actionViewEventModal .event-notes").append('<div class="event-note-content">' + item.Note_Content + '</div>');
							$("#actionViewEventModal .event-notes").append('<div class="note-wrapper"><div class="event-note-content event-note-content-original"><span class="main-note-content">' + item.Note_Content + '</span>&nbsp;&nbsp;&nbsp;<span><i class="fa-solid fa-trash delete-crm-note" data-noteid="'+item.id+'" style="cursor: pointer; font-size: 14px; color: #dc3545;"></i></span>&nbsp;&nbsp;&nbsp;<span><i class="fa-solid fa-pencil edit-note" style="cursor: pointer; font-size: 14px;"></i></span></div><div class="event-note-content-for-edit event-note-content" style="display:none; padding-top:13px;"><textarea class="form-control">' + item.Note_Content + '</textarea>&nbsp;&nbsp;&nbsp;<span><i class="fa-solid fa-save edit-crm-note-done" data-noteid="'+item.id+'" style="cursor: pointer; font-size: 14px;"></i></span></div></div>');
						});
					}
				})
		}

		function prepareRelatedOpportunities(data) {
			console.log(data);

			return new Promise(async (resolve, reject) => {
				if (data.length > 0) {
					var buildingEvents = await Promise.all($.map(data, function (item) {
						// if ((item.Status != "") && (item.Status != "null") && (item.Status != null) && (item.Hold_Date != "") && (item.Hold_End_Date != "")) {
						if ((item.Event_Date != "")) {
							console.log(item);
							//let itStatus = (item.Status != "") && (item.Status != "null") && (item.Status != null) ? item.Status + ' - ' : "";

							/*if( item.Stage == "Outreach" || item.Stage == "Conversation" ){
								var selectedClass = "dealOpen";
							}else */
							var icon = "❓";
							var selectedClass = false;
							if( item.Stage == "Offer" || item.Stage == "Confirmation" ){
								var selectedClass = "dealOpen";//"dealPending";
							}else if( item.Stage == "Pre-Itinerary" || item.Stage == "Itinerary in Progress" || item.Stage == "Pre-Event" || item.Stage == "Post-Event" || item.Stage == "Event Complete" ){
								//var selectedClass = "dealWon";
								if( item.Event_Medium == "Fly-to Event" ){
									//var selectedClass = "flyToEvent";//"dealPending";
									icon = "✈️";
								}else if( item.Event_Medium == "Drive-to Event" ){
									//var selectedClass = "driveToEvent";
									icon = "🚗";
								}else if( item.Event_Medium == "Virtual Visit" || item.Event_Medium == "Pre Recorded Stream" || item.Event_Medium == "Pre Recorded Stream w/Live Q&A" ){
									//var selectedClass = "virtualVisit";
									icon = "💻";
								}
							}

							if( item.Stage != "Lost" && item.Stage != "Outreach" && item.Stage != "Conversation" ){


								return {
									id: item.id,
									type: "crm",
									itemInfo: item,
									content: "",
									title: (item.Event_Name == null)?icon+item.Deal_Name:icon+item.Event_Name,
									start: (item.Event_Date != "" && (item.Event_Date != null)) ? moment(item.Event_Date).format("YYYY-MM-DD HH:mm") : "",
									end: (item.Last_Day_of_Event != "" && (item.Last_Day_of_Event != null)) ? moment(item.Last_Day_of_Event).format("YYYY-MM-DD 23:00") : moment(item.Event_Date).format("YYYY-MM-DD 23:00"),
									className: ["event", selectedClass?selectedClass:"default-event-color"],
									//color: 'red'
								};

							}

						}
					}));

					//setTimeout(async () => {
						// console.log(buildingEvents);
						console.log("from related");
						loadEventInCalendar(buildingEvents).then(function(){resolve();});
						;
						//$.LoadingOverlay("hide");
					//}, 3000);
				}else{
					resolve();
				}
			});
			// else{
			// 	$.LoadingOverlay("hide");
			// }
		}

		async function loadManualEvents(speaker_id) {

			return new Promise( async (resolve, reject) => {
				$.ajax({
					type: 'POST',
					url: ajaxRootUrl,
					data: {
						spid: speaker_id,
						selecteddate: calInitialDate,
						actfor: "getevents",
					},
					dataType: "json",
					success: async function (data) {
						console.log("loadManualEvents");
							console.log(data);
						if (data.status == "success") {
							await prepareManualEvents(data.data);
							resolve();
						}
					},
					error: function (error) {
						console.log(error);
						resolve();
					}
				});
			});
		}

		function load_manual_notes(event_id) {
			$.ajax({
				type: 'POST',
				url: ajaxRootUrl,
				data: {
					event_id: event_id,
					actfor: "getnotes",
				},
				dataType: "json",
				success: function (data) {
					if (data.status == "success") {
						finalData = data.data;
						$.each(finalData, function (key, item) {
							$("#actionViewEventModalManual .event-notes").append('<div class="note-wrapper"><div class="event-note-content event-note-content-original"><span class="main-note-content">' + item.notes + '</span>&nbsp;&nbsp;&nbsp;<span><i class="fa-solid fa-trash delete-note" data-noteid="'+item.id+'" style="cursor: pointer; font-size: 14px; color: #dc3545;"></i></span>&nbsp;&nbsp;&nbsp;<span><i class="fa-solid fa-pencil edit-note" style="cursor: pointer; font-size: 14px;"></i></span></div><div class="event-note-content-for-edit event-note-content" style="display:none; padding-top:13px;"><textarea class="form-control">' + item.notes + '</textarea>&nbsp;&nbsp;&nbsp;<span><i class="fa-solid fa-save edit-note-done" data-noteid="'+item.id+'" style="cursor: pointer; font-size: 14px;"></i></span></div></div>');
						});
					}
				},
				error: function (error) {
					console.log(error);
				}
			})
		}

		function fetch_speaker_details_by_id(speakerId) {

	    	return new Promise(resolve => {
		        $.ajax({
		        	type: 'POST',
		        	url: dataURL+"getAuthorInfoById",
		        	data: {
		        		authorId: speakerId
		        	},
		        	dataType: "json",
		        	success: async function (data) {
		        		//if (data.status == "success") {
		        			console.log('author_manual_event_data');
		        			console.log(data);
		        			resolve(data);
		        		//}
		        	},
		        	error: function (error) {
		        		console.log(error);
		        		resolve();
		        	}
		        });
		    });

		}

		async function prepareManualEvents(data) {
			console.log(data.length);
			if (data.length > 0) {
				//$.LoadingOverlay("show");
				var buildingEvents = await Promise.all($.map(data, async function (item) {
					// if((item.Status != "") && (item.Hold_Date != "") && (item.Hold_End_Date != "")){

					const speakerDetails = await fetch_speaker_details_by_id(item.speaker_id);

					// console.log("hello");
					// console.log( speakerDetails.data[0].Name );
					// console.log( item.speaker_id );

					if( item.custom_event_type == "Publisher Supported Event" ){
						var className = "publisherSupportedEvent";
					}else if( item.custom_event_type == "Travel Day" ){
						var className = "travelDay";
					}else{
						var className = "CustomEvent";
					}

					return {
						id: item.id,
						type: "manual",
						itemInfo: item,
						//title: speakerDetails.Name + ' - ' +item.title,
						title: item.title,
						modalEventName: item.title,
						content: item.notes,
						start: (item.start != "" && (item.start != null)) ? moment(item.start).format("YYYY-MM-DD HH:mm") : "",
						end: (item.end != "" && (item.end != null)) ? moment(item.end).format("YYYY-MM-DD 23:00") : "",
						className: ["event", item.id + "_cEvent "+className],
						// textColor:"#000",
						// backgroundColor: '#fff'
					};
				}));

				// setTimeout(async () => {
				// 	console.log("from manual");
				// 	console.log(buildingEvents);
				// 	//$.LoadingOverlay("hide");
				await loadEventInCalendar(buildingEvents);
				// }, 3000);
			}
		}

		$(document).on("change", "#recurringCheck", function () {
			if ($(this).is(':checked')) {
				$(".for_recurring").show();
				$(".evEndDateDiv").hide();
				$(".evEndDate").val($(".evStartDate").val());
				$(".for_recurring .evUnit").prop("required", true);
				$(".for_recurring .evInterval").prop("required", true);
			} else {
				$(".for_recurring").hide();
				$(".evEndDateDiv").show();
				$(".for_recurring").find(":input").prop("required", false);
				$(".for_recurring .evUnit").val("");
				$(".for_recurring .evInterval").val("");
				$(".for_recurring .evUntil").val("");
			}
		})

		//Save manual event 
		$(".saveEventForm").submit(function (e) {
			//prevent Default functionality
			e.preventDefault();
			var fd = new FormData($(this)[0]);
			fd.append('actfor', "saveevent");
			//fd.append('speaker_id', speakerId);
			fd.append('start', moment($(this).find('.evStartDate').val(), 'MM-DD-YYYY HH:mm').format("YYYY-MM-DD HH:mm"));
			fd.append('end', moment($(this).find('.evEndDate').val(), 'MM-DD-YYYY HH:mm').format("YYYY-MM-DD HH:mm"));
			fd.append('custom_event_type', $(this).find("input[name='custom_event_type']:checked").val());
			let rec_until = ($(this).find('.evUntil').val() != "") ? moment($(this).find('.evUntil').val(), 'MM-DD-YYYY').format("YYYY-MM-DD") : "";
			fd.append('rec_until', rec_until);

			let stDate = moment($(this).find('.evStartDate').val(), 'MM-DD-YYYY HH:mm').format("YYYY-MM-DD HH:mm");
			let enDate = moment($(this).find('.evEndDate').val(), 'MM-DD-YYYY HH:mm').format("YYYY-MM-DD HH:mm");
			if (stDate > enDate) {
				$(".evErrMsg").html('<span class="text-danger">Start Date can not be greated than end date.</span>');
				return false;
			} else if ((rec_until != "") && (stDate > rec_until)) {
				$(".evErrMsg").html('<span class="text-danger">Start Date can not be greated than until date.</span>');
				return false;
			} else {
				$(".evErrMsg").html('');
				$.ajax({
					type: "POST",
					enctype: 'multipart/form-data',
					url: ajaxRootUrl,
					data: fd,
					processData: false,
					contentType: false,
					cache: false,
					timeout: 800000,
					dataType: "json",
					success: function (data) {
						// $("#output").text(data);
						console.log("SUCCESS : ", data);
						// $("#btnSubmit").prop("disabled", false);
						if (data.status == "success") {
							$("#actionEventModal input:not(:radio)").val("");
							$("#actionEventModal #recurringCheck").prop("checked", false);
							$("#actionEventModal").modal("hide");
							// loadManualEvents(speakerId);
							// refresh_widget();

							var fValYMDst = new Date(stDate).toLocaleString("en-US", { timeZone: timeZoneCountry });
							var fValYMDed = (enDate != "") ? new Date(enDate).toLocaleString("en-US", { timeZone: timeZoneCountry }) : fValYMDst;
							console.log("--stDate = " + stDate);
							console.log("--enDate = " + enDate);
							console.log("--fValYMDst = " + fValYMDst);
							console.log("--fValYMDed = " + fValYMDed);
							console.log("--speakerId = " + speakerId);
							//conflict_check_manual(speakerId, fValYMDst, fValYMDed);

							// loadCalendar([]);
							calendar.removeAllEvents();
							//$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
							if( speakerId != "" && speakerId != "all" ){
								//pull_speaker_opp_linking(speakerId);
								//loadManualEvents(speakerId);
								loadCalendar();
							}else{
								load_all_event();
								load_all_crm_event();
							}
						}
					},
					error: function (e) {
						console.log("ERROR : ", e);
					}
				});
			}

		});

		function conflict_check_manual(speaker_id, stVal, edVal) {
			ZOHO.CRM.API.searchRecord({ Entity: "Opportunities_X_Speakers", sort_order: "desc", sort_by: "Created_Time", Type: "criteria", Query: "(Shortlisted_Speakers:equals:" + speaker_id + ")", per_page: 200, page: 1 })
				.then(function (response) {
					var fmodule = "Opportunities_X_Speakers";

					console.log("onAssign Conflict ins stVal :" + stVal);
					console.log("onAssign Conflict ins date stVal :" + new Date(stVal));

					console.log("onAssign Conflict ins edVal :" + edVal);
					console.log("onAssign Conflict ins date edVal :" + new Date(edVal));

					if (response.data) {
						jQuery.each(response.data, function (i, item) {
							console.log("onAssign Conflict item Hold_Date id :" + item.id);
							console.log("onAssign Conflict item Hold_Date tt :" + item.Hold_Date);
							console.log("onAssign Conflict item Hold_End_Date tt :" + item.Hold_End_Date);

							console.log("onAssign Conflict item Hold_Date :" + new Date(item.Hold_Date));
							console.log("onAssign Conflict item Hold_End_Date :" + new Date(item.Hold_End_Date));

							if ((new Date(stVal) >= new Date(item.Hold_Date)) && (new Date(stVal) <= new Date(item.Hold_End_Date)) || (new Date(edVal) >= new Date(item.Hold_Date)) && (new Date(edVal) <= new Date(item.Hold_End_Date)) ) {

								var upd_conf = {
									Entity: fmodule,
									APIData: {
										"id": item.id,
										"Conflict_Check": "Conflict found. Please visit the Speaker's record and reference the Speaker Calendar to resolve.",
									},
									// Trigger:["workflow"]
								};
								ZOHO.CRM.API.updateRecord(upd_conf).then(function (cresponse) {
									console.log(cresponse)
									if (cresponse.data && cresponse.data[0].code == "SUCCESS") {
										// 	//If you do anything after success
										// refresh_widget();
									}
								});
								return false;
							}
						});
					}
				});
		}


		$(document).on('click', '.saveEventNote', function (e) {
			var event_note = $(this).closest("form").find(".event-note").val();
			if (event_note.trim() == "") {
				$(".msg_div").html('<span class="text-danger">Note field can not be empty.</span>');
				return false;
			}
			var module_id = $(this).data("moduleid");
			var module = $(this).data("module");
			console.log("module_id = ", module_id)
			console.log("module = ", module)
			if (module == "CustomEvent" && module_id != "") {
				var fd = new FormData();
				fd.append('actfor', "savenote");
				fd.append('event_id', module_id);
				fd.append('notes', event_note);
				fd.append('speaker_id', speakerId);
				$.ajax({
					type: "POST",
					enctype: 'multipart/form-data',
					url: ajaxRootUrl,
					data: fd,
					processData: false,
					contentType: false,
					cache: false,
					timeout: 800000,
					dataType: "json",
					success: function (data) {
						// $("#output").text(data);
						console.log("SUCCESS : ", data);
						// $("#btnSubmit").prop("disabled", false);
						if (data.status == "success") {
							$("#actionViewEventModalManual .event-notes").html("");
							$("#actionViewEventModalManual .event-note").val("");
							load_manual_notes(module_id);
						}
					},
					error: function (e) {
						console.log("ERROR : ", e);
					}
				});



			} else if (module != "" && module_id != "") {
				var recordData = {
					"Parent_Id": module_id,
					"se_module": module,
					"Note_Content": event_note
				}
				ZOHO.CRM.API.insertRecord({ Entity: "Notes", APIData: recordData, Trigger: [] }).then(function (data) {
					if (data.data && data.data[0].code == "SUCCESS") {
						$("#actionViewEventModal .event-notes").html("");
						$("#actionViewEventModal .event-note").val("");
						load_event_notes(module_id, module);
					} else {
						console.log(data);
					}
				});
			}
		});

		$(document).on('focus click', '.hoverEdit', function (e) {
			$(".saveCancelSpan").hide();
			$(this).closest(".editorDiv").find(".saveCancelSpan").show();
		});
		$(document).on('click', '.cancelAct', function (e) {
			$(".saveCancelSpan").hide();
			// $(this).closest(".editorDiv").find(".saveCancelSpan").hide();
		});


		$(document).on('click', '.eventDelete', function (e) {
			$("#actionViewEventModalManual").modal('hide');
			var module_id = $("#actionViewEventModalManual").data("moduleid");
			var module = $("#actionViewEventModalManual").data("module");
			var recurring = $("#actionViewEventModalManual").data("recurring");
			var recparent = $("#actionViewEventModalManual").data("recparent");
			console.log(recurring);
			console.log(recparent);

			$('<div></div>').appendTo('body').html('<div><h6>Are you sure?</h6></div>').dialog({
				modal: true,
				title: 'Delete',
				zIndex: 10000,
				autoOpen: true,
				width: '500px',
				resizable: false,
				buttons: {
					Yes: function () {
						// $(obj).removeAttr('onclick');                                
						// $(obj).parents('.Parent').remove();
						// $('body').append('<h1>Confirm Dialog Result: <i>Yes</i></h1>');
						const _thisDialog = $(this);
						var fd = new FormData();
						fd.append('actfor', "deleteevent");
						fd.append('event_id', module_id);
						fd.append('recurring', recurring);
						fd.append('recparent', recparent);
						$.ajax({
							type: "POST",
							enctype: 'multipart/form-data',
							url: ajaxRootUrl,
							data: fd,
							processData: false,
							contentType: false,
							cache: false,
							timeout: 800000,
							dataType: "json",
							success: function (data) {
								console.log("SUCCESS : ", data);
								if (data.status == "success") {
									// loadCalendar([]);
									calendar.removeAllEvents();
									//$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
									loadCalendar();
								}
								_thisDialog.dialog("close");
							},
							error: function (e) {
								console.log("ERROR : ", e);
								_thisDialog.dialog("close");
							}
						});

						// $(this).dialog("close");
					},
					No: function () {
						// $('body').append('<h1>Confirm Dialog Result: <i>No</i></h1>');
						$(this).dialog("close");
					}
				},
				close: function (event, ui) {
					$(this).remove();
				}
			});


		});


		$(document).on('click', '.eventDeleteRecur', function (e) {
			$("#actionViewEventModal").modal('hide');
			var module_id = $("#actionViewEventModal").data("moduleid");
			var module = $("#actionViewEventModal").data("module");
			var recurring = $("#actionViewEventModal").data("recurring");
			var recparent = $("#actionViewEventModal").data("recparent");
			console.log(recurring);
			console.log(recparent);

			$('<div></div>').appendTo('body').html('<div><h6>Are you sure?</h6></div>').dialog({
				modal: true,
				title: 'Delete',
				zIndex: 10000,
				autoOpen: true,
				width: '500px',
				resizable: false,
				buttons: {
					Yes: function () {
						// $(obj).removeAttr('onclick');                                
						// $(obj).parents('.Parent').remove();
						// $('body').append('<h1>Confirm Dialog Result: <i>Yes</i></h1>');
						const _thisDialog = $(this);
						var fd = new FormData();
						fd.append('actfor', "deleterecurevent");
						fd.append('event_id', module_id);
						fd.append('recurring', recurring);
						fd.append('recparent', recparent);
						$.ajax({
							type: "POST",
							enctype: 'multipart/form-data',
							url: ajaxRootUrl,
							data: fd,
							processData: false,
							contentType: false,
							cache: false,
							timeout: 800000,
							dataType: "json",
							success: function (data) {
								console.log("SUCCESS : ", data);
								if (data.status == "success") {
									// loadCalendar([]);
									calendar.removeAllEvents();
									pull_speaker_opp_linking(speakerId);
									loadManualEvents(speakerId);
								}
								_thisDialog.dialog("close");
							},
							error: function (e) {
								console.log("ERROR : ", e);
								_thisDialog.dialog("close");
							}
						});

						// $(this).dialog("close");
					},
					No: function () {
						// $('body').append('<h1>Confirm Dialog Result: <i>No</i></h1>');
						$(this).dialog("close");
					}
				},
				close: function (event, ui) {
					$(this).remove();
				}
			});


		});

		// $('#date_months').on('change', function () {
		// 	console.log(123);
		// 	const selectedDate = moment($(this).val(), 'MMMM YYYY').format("YYYY-MM-01")
		// 	calendar.gotoDate(selectedDate);
		// 	//buildMonthList();
		// });

		// buildMonthList();
		function buildMonthList() {
			var month = calendar.getDate();
			console.log("month = ", month)
			$("#date_months").val(moment(month).format('MMMM YYYY'));
			calInitialDate = moment(month).format("YYYY-MM-DD");
			console.log("calInitialDate : ", calInitialDate);
			console.log("speakerId : ", speakerId);

			calendar.removeAllEvents();

			//$.LoadingOverlay("show");
			if (speakerId != "" && speakerId != "all") {
				$.LoadingOverlay("show");
				loadManualEvents(speakerId).then(async function(){
					pull_speaker_opp_linking(speakerId, 1).then(function(){
						console.log("here 111");
						pull_speaker_not_confirmed(speakerId).then(function(){
							console.log("here 222");
							$.LoadingOverlay("hide");
						}).catch(error => {
							console.log("error 1");
							console.log(error);
						    $.LoadingOverlay("hide");
						  });
					}).catch(error => {
						console.log("error 2");
						console.log(error);
					    $.LoadingOverlay("hide");
					  });
				}).catch(error => {
					console.log("error 3");
					console.log(error);
				    $.LoadingOverlay("hide");
				  });
			}
			else{
				load_all_event();
				load_all_crm_event();
				$(".msg_div").html('');
			// 	setTimeout(() => {
			//         loadManualEvents(speakerId);
			// 		pull_speaker_opp_linking(speakerId, 1);
			//     }, 1500);
			}
		}

		function load_all_event(frecord_id = record_id, page = 1) {
			$.ajax({
				type: 'POST',
				url: ajaxRootUrl,
				data: {
					selecteddate: calInitialDate,
					actfor: "get_all_events",
				},
				dataType: "json",
				success: function (data) {
					if (data.status == "success") {
						// $(".msg_div").html(data.message);
						// setTimeout(function(){
						// 	$(".msg_div").html("");
						// }, 2000);
						// $(".CustomEvent").closest(".fc-timegrid-event-harness").remove();
						// $(".CustomEvent").closest(".fc-daygrid-event-harness").remove();
						prepareManualEvents(data.data);
					}
				},
				error: function (error) {
					console.log(error);
				}
			});
		}

		$(document).on('click', '.ReloadPage', function () {
			refresh_widget();
		});

		function refresh_widget() {
			//$(".msg_div").html('<span class="text-success">Refreshing...</span>');
			// cache.delete();
			// $('html[manifest=saveappoffline.appcache]').attr('content', '');
			// window.location.reload(true);
			loadCalendar();
		}

		// close the widget
		function close_widget() {
			// Close Widget Popup
			// ZOHO.CRM.UI.Popup.close().then(function(data){});
			ZOHO.CRM.UI.Popup.closeReload().then(function (data) { });
		}

		//Allow numeric with decimal
		$(document).on("keypress keyup blur", ".allownumericwithdecimal", function (event) {
			$(this).val($(this).val().replace(/[^0-9\.]/g, ''));
			if ((event.which != 46 || $(this).val().indexOf('.') != -1) && (event.which < 48 || event.which > 57)) {
				event.preventDefault();
			}
		});

		//Allow numeric without decimal
		$(document).on("keypress keyup blur", ".allownumericwithoutdecimal", function (event) {
			$(this).val($(this).val().replace(/[^0-9]/g, ""));
			if ((event.which < 48 || event.which > 57)) {
				event.preventDefault();
			}
		});
		//End











		var timer, delay = 500;
		// dropdown select search
		$(document).on('keyup', '.dropdownsearch', function () {
			var value = $(this).val();
			var $parent = $(this).closest('.dropdown');
			clearTimeout(timer);
			timer = setTimeout(function () {
				search_here(value, $parent);
			}, delay);
		});

		function search_here(value, $parent) {
			var page = 1;
			var rowID = $parent.data('rid');

			var selected_id = $parent.find(".selectedItem").val();
			var selected_name = $parent.find(".selectedItem").data("text");
			var is_selected = "";

			if (value.length >= 3) {
				// var jobdata = {"id": $parent.find(".selectedItem").val(), "name" : $parent.find(".selectedItem").data("text")};

				ZOHO.CRM.API.searchRecord({ Entity: "Jobs", sort_order: "desc", sort_by: "Created_Time", Type: "criteria", Query: "(Name:starts_with:" + value + ")", per_page: 200, page: page })
					.then(function (response) {
						if (response.data) {
							push_to_option(response, selected_id, $parent);
						} else {
							$('ul li:not(.searchInput)', $parent).remove();
							if (!$('.noresults', $parent).length) {
								$('ul', $parent).append('<li class="noresults">No results found</li>');
							}
						}
					});
			}

			if (value.length == 0) {
				ZOHO.CRM.API.getAllRecords({ Entity: "Jobs", sort_order: "desc", sort_by: "Created_Time", per_page: 200, page: page })
					.then(function (response) {
						if (response.data) {
							push_to_option(response, selected_id, $parent);
						} else {
							$('ul li:not(.searchInput)', $parent).remove();
							if (!$('.noresults', $parent).length) {
								$('ul', $parent).append('<li class="noresults">No results found</li>');
							}
						}
					});
			}
		}

		function push_to_option(response, selected_id, $parent) {
			$('ul li:not(.searchInput)', $parent).remove();
			response.data.forEach(function (item) {

				var Job_Id = (item.id != null) ? item.id : '';
				is_selected = (selected_id == Job_Id) ? "selected" : "";

				var Job_Name = (item.Name != null) ? item.Name + "<br>" : '';
				var Job_Type = (item.Job_Type != null) ? "<strong>Type:</strong> " + item.Job_Type + "<br>" : '';
				var Job_Status = (item.Job_Status != null) ? "<strong>Status:</strong> " + item.Job_Status + "<br>" : '';
				var Completion_Date = (item.Completion_Date != null) ? "<strong>Date:</strong> " + item.Completion_Date + "<br>" : '';
				var Description = (item.Description != null) ? item.Description : '';
				var Job_Full_Name = Job_Name + Job_Type + Job_Status + Completion_Date;


				var tootltip = '<img src="images/info-circle-fill.png" class="pt5" data-toggle="tooltip" data-placement="top" title="' + Description + '" width="18">';

				$('ul', $parent).append('<li data-id="' + Job_Id + '" data-text="' + Job_Full_Name + '" class="' + is_selected + '">' + Job_Full_Name + tootltip + '</li>');
			});

			if (response.length == 0) {
				if (!$('.noresults', $parent).length) {
					$('ul', $parent).append('<li class="noresults">No results found</li>');
				}
			} else {
				$('.noresults', $parent).remove();
			}
		}

		$(document).on('click', '.dropdown button', function () {
			$('.dropdown ul').hide();
			$(this).siblings('ul').show();
			$(this).siblings('ul').children('.searchInput').children('input').focus();

			var winH = $(window).height();
			var eleTop = $(this).offset().top;
			var eleOwn = $(this).outerHeight(true);
			var actualBottom = winH - (eleTop + eleOwn);
			$(this).siblings('ul').css({ "height": actualBottom + "px" });
		})

		$(document).on('click', '.dropdown ul li:not(.searchInput)', function () {
			var line_text = $(this).html();
			$(this).parent('ul').siblings('button').html(line_text);
			$(this).parent('ul').hide();
			$(this).parent('ul').find('.dropdownsearch').val('');
			$(this).parent('ul').find('li').removeClass('selected');
			$(this).closest('.customDropdown').find('.selectedItem').val($(this).data('id'));
			$(this).addClass('selected');

		});

		$(document).on('click', 'html', function (e) {
			if ($(e.target).parents('.dropdown').length == 0 && $(e.target).siblings('.dropdown').length == 0 && $(e.target).children('.dropdown').length == 0) {
				if ($(".dropdown ul").is(":visible")) {
					$('.dropdown ul').hide();
					$('.dropdownsearch').val('').keyup();
				}
			}
		});

		//enable tooltip
		$(function () {
			$('[data-toggle="tooltip"]').tooltip();
			// $(".fieldDate").datepicker({
			// 	dateFormat: 'dd-mm-yy',
			// 	changeMonth: true,
			// 	changeYear: true
			// });
			$('.fieldDate').datetimepicker({
				timepicker: true,
				format: 'm-d-Y',
				timepickerScrollbar: false,
				scrollInput: false,
				scrollMonth: false
			});
			$("#date_months").datepicker({
				dateFormat: 'MM yy',
				changeMonth: true,
				changeYear: true,
				onClose: function (dateText, inst) {
					var selectedDate = inst.selectedYear+'-'+(inst.selectedMonth+1)+'-'+inst.selectedDay;
					var momentDate = moment(selectedDate, 'YYYY-M-D').format('YYYY-MM-DD');
					$(this).datepicker('option', 'defaultDate', new Date(inst.selectedYear, inst.selectedMonth, inst.selectedDay));
					$(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, inst.selectedDay));
					calendar.gotoDate( momentDate );
				}
			});
		});


	})
	/*
	 * initialize the widget.
	 */
	ZOHO.embeddedApp.init();

};