var calendar;
function initializeWidget() {
	/*
	 * Subscribe to the EmbeddedApp onPageLoad event before initializing the widget 
	 * https://www.zoho.com/crm/developer/docs/javascript-sdk/sample-codes.html
	 * https://help.zwidgets.com/help/latest/index.html
	 */
	ZOHO.embeddedApp.on("PageLoad", function (data) {

		var ajaxRootUrl = "https://aucrm.authorsunbound.com/spk_v2/manualEventController/manualEventHandler";
		var dataURL = "https://aucrm.authorsunbound.com/spk_v2/WebTabCalendarController/";
		var calendarEl;
		var calInitialDate = moment().format("YYYY-MM-DD");
		var timeZoneSettings = "+10:00";
		var timeZoneCountry = "Australia/Melbourne";
		var selectedStage = 'confirmed';
		var loadedView = '';

		// initialize Calendar
		calendarEl = document.getElementById('deal_calendar_main');

		function load_all_authors(pagesetup = 1){

			$.ajax({
				type: "POST",
				enctype: 'multipart/form-data',
				url: dataURL+"getAllAuthors",
				data: {actfor: "nothing"},
				cache: false,
				timeout: 800000,
				dataType: "json",
				success: function (data) {
					if (data) {
						finalData = data;
						jQuery.each(finalData, function (i, item) {
							let Shortlisted_Speaker = (item.Name) ? item.Name : "";
							let Shortlisted_Speaker_Id = (item.module_id) ? item.module_id : "";
							$("#selectField").append("<option value='"+Shortlisted_Speaker_Id+"'>"+Shortlisted_Speaker+"</option>");
						});
					}
				},
				error: function (e) {
					console.log("ERROR : ", e);
				}
			});
		}

		//Start edit event name

		$(document).on("click",".edit-event-name",function(){

			$(".event-name-box").hide();
			$(".event-name-for-edit").show();

		});

		$(document).on("click",".submit-event-name",function(){

			var thisPointer = $(this);
			$.ajax({
				type: "POST",
				enctype: 'multipart/form-data',
				url: ajaxRootUrl,
				data: {actfor: "updateEvent", title: $(this).closest("div").find('.edit-event-name-value').val(), id: $(this).closest(".event-detail").find('.event-id-for-edit').val()},
				cache: false,
				timeout: 800000,
				dataType: "json",
				success: function (data) {
					// $("#output").text(data);
					console.log("SUCCESS : ", data);
					// $("#btnSubmit").prop("disabled", false);
					if (data.status == "success") {
						console.log(thisPointer.closest('div').find(".edit-event-name-value").val());
						$("#actionViewEventModalManual .event-title").html(thisPointer.closest('div').find(".edit-event-name-value").val());
						$(".event-name-box").show();
		    			$(".event-name-for-edit").hide();
						calendar.removeAllEvents();
						//$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
						loadCalendar();
					}
				},
				error: function (e) {
					console.log("ERROR : ", e);
				}
			});

		});

		//End edit event name

		//start edit event date

		$(document).on("click",".edit-start-date",function(){

			$(".start-date-box").hide();
			$(".start-date-box-for-edit").show();

		});

		$(document).on("click",".edit-end-date",function(){

			$(".end-date-box").hide();
			$(".end-date-box-for-edit").show();

		});

		$('#actionViewEventModalManual').on('hidden.bs.modal', function () {
		    $(".start-date-box").show();
		    $(".start-date-box-for-edit").hide();
		    $(".event-name-box").show();
		    $(".event-name-for-edit").hide();
		    $(".end-date-box").show();
		    $(".end-date-box-for-edit").hide();
		    $(".event-edit-original").show();
		    $(".edit-description").show();
		    $(".ev-description-edit").hide();
		    $(".edit-description-ok").hide();
		    $(".event-note-content-original").show();
		    $(".event-note-content-for-edit").hide();
		});

		$(document).on("click",".submit-start-date",function(){

			var thisPointer = $(this);
			$.ajax({
				type: "POST",
				enctype: 'multipart/form-data',
				url: ajaxRootUrl,
				data: {actfor: "updateEvent", start: moment($(this).closest("div").find('.edit-start-date-value').val(), 'MM-DD-YYYY HH:mm').format("YYYY-MM-DD HH:mm"), id: $(this).closest(".event-detail").find('.event-id-for-edit').val()},
				cache: false,
				timeout: 800000,
				dataType: "json",
				success: function (data) {
					// $("#output").text(data);
					console.log("SUCCESS : ", data);
					// $("#btnSubmit").prop("disabled", false);
					if (data.status == "success") {
						console.log(thisPointer.closest('div').find(".edit-start-date-value").val());
						$("#actionViewEventModalManual .event-date").html(moment(thisPointer.closest('div').find(".edit-start-date-value").val()).format("MM-DD-YYYY"));
						$(".start-date-box").show();
						$(".start-date-box-for-edit").hide();
						calendar.removeAllEvents();
						//$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
						loadCalendar();
					}
				},
				error: function (e) {
					console.log("ERROR : ", e);
				}
			});

		});

		$(document).on("click",".submit-end-date",function(){

			var thisPointer = $(this);
			$.ajax({
				type: "POST",
				enctype: 'multipart/form-data',
				url: ajaxRootUrl,
				data: {actfor: "updateEvent", end: moment($(this).closest("div").find('.edit-end-date-value').val(), 'MM-DD-YYYY HH:mm').format("YYYY-MM-DD HH:mm"), id: $(this).closest(".event-detail").find('.event-id-for-edit').val()},
				cache: false,
				timeout: 800000,
				dataType: "json",
				success: function (data) {
					// $("#output").text(data);
					console.log("SUCCESS : ", data);
					// $("#btnSubmit").prop("disabled", false);
					if (data.status == "success") {
						$("#actionViewEventModalManual .event-last-day").html(moment(thisPointer.closest('div').find(".edit-end-date-value").val()).format("MM-DD-YYYY"));
						$(".end-date-box").show();
						$(".end-date-box-for-edit").hide();
						calendar.removeAllEvents();
						//$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
						loadCalendar();
					}
				},
				error: function (e) {
					console.log("ERROR : ", e);
				}
			});

		});

		$(document).on("click",".edit-description",function(){

			$(".event-edit-original").hide();
			$(".ev-description-edit").show();
			$(".edit-description-ok").show();

		});

		$(document).on("click",".edit-description-ok",function(){

			var thisPointer = $(this);
			$.ajax({
				type: "POST",
				enctype: 'multipart/form-data',
				url: ajaxRootUrl,
				data: {actfor: "updateEvent", description: $(this).closest(".event-detail").find('.ev-description-edit').val(), id: $(this).closest(".event-detail").find('.event-id-for-edit').val()},
				cache: false,
				timeout: 800000,
				dataType: "json",
				success: function (data) {
					// $("#output").text(data);
					console.log("SUCCESS : ", data);
					// $("#btnSubmit").prop("disabled", false);
					if (data.status == "success") {
						$("#actionViewEventModalManual .event-description-manual").html(thisPointer.closest(".event-detail").find('.ev-description-edit').val());
						$(".event-edit-original").show();
						$(".edit-description").show();
						$(".ev-description-edit").hide();
						$(".edit-description-ok").hide();
						calendar.removeAllEvents();
						//$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
						loadCalendar();
					}
				},
				error: function (e) {
					console.log("ERROR : ", e);
				}
			});

		});

		//end edit event date

		//start edit note

		$(document).on("click",".edit-note",function(){

			$(this).closest(".note-wrapper").find(".event-note-content-original").hide();
			$(this).closest(".note-wrapper").find(".event-note-content-for-edit").show();

		});

		$(document).on("click",".edit-note-done",function(){

			var thisPointer = $(this);
			$.ajax({
				type: "POST",
				enctype: 'multipart/form-data',
				url: ajaxRootUrl,
				data: {actfor: "updateNote", notes: $(this).closest(".note-wrapper").find('textarea').val(), id: $(this).data("noteid")},
				cache: false,
				timeout: 800000,
				dataType: "json",
				success: function (data) {
					// $("#output").text(data);
					console.log("SUCCESS : ", data);
					// $("#btnSubmit").prop("disabled", false);
					if (data.status == "success") {
						thisPointer.closest(".note-wrapper").find(".main-note-content").html(thisPointer.closest(".note-wrapper").find('textarea').val());
						thisPointer.closest(".note-wrapper").find(".event-note-content-original").show();
						thisPointer.closest(".note-wrapper").find(".event-note-content-for-edit").hide();
						//calendar.removeAllEvents();
						//$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
						//loadCalendar();
					}
				},
				error: function (e) {
					console.log("ERROR : ", e);
				}
			});

		});

		$(document).on("click",".edit-crm-note-done",function(){

			thisPointer = $(this);

			var config={
			  Entity:"Notes",
			  APIData:{
			        "id": $(this).data("noteid"),
			        "Note_Content": $(this).closest(".note-wrapper").find('textarea').val()
			  }
			}
			console.log( config );
			ZOHO.CRM.API.updateRecord(config)
			.then(function(data){
				console.log("Note Update Info");
			    console.log(data);
			    thisPointer.closest(".note-wrapper").find(".main-note-content").html(thisPointer.closest(".note-wrapper").find('textarea').val());
			    thisPointer.closest(".note-wrapper").find(".event-note-content-original").show();
			    thisPointer.closest(".note-wrapper").find(".event-note-content-for-edit").hide();
			});

		});

		$(document).on('click', '.delete-note', function (e) {
			//$("#actionViewEventModalManual").modal('hide');
			var note_id = $(this).data("noteid");
			var thisPointer = $(this);

			$('<div></div>').appendTo('body').html('<div><h6>Are you sure?</h6></div>').dialog({
				modal: true,
				title: 'Delete',
				zIndex: 10000,
				autoOpen: true,
				width: '500px',
				resizable: false,
				buttons: {
					Yes: function () {
						// $(obj).removeAttr('onclick');                                
						// $(obj).parents('.Parent').remove();
						// $('body').append('<h1>Confirm Dialog Result: <i>Yes</i></h1>');
						const _thisDialog = $(this);
						var fd = new FormData();
						fd.append('actfor', "deletenote");
						fd.append('note_id', note_id);
						$.ajax({
							type: "POST",
							enctype: 'multipart/form-data',
							url: ajaxRootUrl,
							data: fd,
							processData: false,
							contentType: false,
							cache: false,
							timeout: 800000,
							dataType: "json",
							success: function (data) {
								console.log("SUCCESS : ", data);
								_thisDialog.dialog("close");
								if (data.status == "success") {
									// loadCalendar([]);
									thisPointer.closest(".note-wrapper").remove();
									//calendar.removeAllEvents();
									//$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
									//loadCalendar();
								}
							},
							error: function (e) {
								console.log("ERROR : ", e);
								_thisDialog.dialog("close");
							}
						});

						// $(this).dialog("close");
					},
					No: function () {
						// $('body').append('<h1>Confirm Dialog Result: <i>No</i></h1>');
						$(this).dialog("close");
					}
				},
				close: function (event, ui) {
					$(this).remove();
				}
			});

			return false;
		});

		$(document).on('click', '.delete-crm-note', function (e) {
			//$("#actionViewEventModal").modal('hide');
			var note_id = $(this).data("noteid");
			var thisPointer = $(this);

			$('<div></div>').appendTo('body').html('<div><h6>Are you sure?</h6></div>').dialog({
				modal: true,
				title: 'Delete',
				zIndex: 10000,
				autoOpen: true,
				width: '500px',
				resizable: false,
				buttons: {
					Yes: function () {
						const _thisDialog = $(this);
						ZOHO.CRM.API.deleteRecord({Entity:"Notes",RecordID: note_id})
						.then(function(data){
							console.log("Note delete info");
						    console.log(data);
						    _thisDialog.dialog("close");
						    thisPointer.closest(".note-wrapper").remove();
						})
					},
					No: function () {
						// $('body').append('<h1>Confirm Dialog Result: <i>No</i></h1>');
						$(this).dialog("close");
					}
				},
				close: function (event, ui) {
					$(this).remove();
				}
			});

			return false;
		});

		//end edit note

		$(document).on('click', '.eventDelete', function (e) {
			$("#actionViewEventModalManual").modal('hide');
			var module_id = $("#actionViewEventModalManual").data("moduleid");
			var module = $("#actionViewEventModalManual").data("module");
			var recurring = $("#actionViewEventModalManual").data("recurring");
			var recparent = $("#actionViewEventModalManual").data("recparent");
			console.log(recurring);
			console.log(recparent);

			$('<div></div>').appendTo('body').html('<div><h6>Are you sure?</h6></div>').dialog({
				modal: true,
				title: 'Delete',
				zIndex: 10000,
				autoOpen: true,
				width: '500px',
				resizable: false,
				buttons: {
					Yes: function () {
						// $(obj).removeAttr('onclick');                                
						// $(obj).parents('.Parent').remove();
						// $('body').append('<h1>Confirm Dialog Result: <i>Yes</i></h1>');
						const _thisDialog = $(this);
						var fd = new FormData();
						fd.append('actfor', "deleteevent");
						fd.append('event_id', module_id);
						fd.append('recurring', recurring);
						fd.append('recparent', recparent);
						$.ajax({
							type: "POST",
							enctype: 'multipart/form-data',
							url: ajaxRootUrl,
							data: fd,
							processData: false,
							contentType: false,
							cache: false,
							timeout: 800000,
							dataType: "json",
							success: function (data) {
								console.log("SUCCESS : ", data);
								_thisDialog.dialog("close");
								if (data.status == "success") {
									// loadCalendar([]);
									calendar.removeAllEvents();
									//$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
									loadCalendar();
								}
							},
							error: function (e) {
								console.log("ERROR : ", e);
								_thisDialog.dialog("close");
							}
						});

						// $(this).dialog("close");
					},
					No: function () {
						// $('body').append('<h1>Confirm Dialog Result: <i>No</i></h1>');
						$(this).dialog("close");
					}
				},
				close: function (event, ui) {
					$(this).remove();
				}
			});


		});

		$('#filterDropdown').on('change', function () {
			selectedStage = $(this).val();
			buildMonthList();
		});

		$(".saveEventForm").submit(function (e) {
			//prevent Default functionality
			e.preventDefault();
			var fd = new FormData($(this)[0]);
			fd.append('actfor', "saveevent");
			//fd.append('speaker_id', speakerId);
			fd.append('start', moment($(this).find('.evStartDate').val(), 'MM-DD-YYYY HH:mm').format("YYYY-MM-DD HH:mm"));
			fd.append('end', moment($(this).find('.evEndDate').val(), 'MM-DD-YYYY HH:mm').format("YYYY-MM-DD HH:mm"));
			//let rec_until = ($(this).find('.evUntil').val() != "") ? moment($(this).find('.evUntil').val(), 'MM-DD-YYYY').format("YYYY-MM-DD") : "";
			//fd.append('rec_until', rec_until);

			let stDate = moment($(this).find('.evStartDate').val(), 'MM-DD-YYYY HH:mm').format("YYYY-MM-DD HH:mm");
			let enDate = moment($(this).find('.evEndDate').val(), 'MM-DD-YYYY HH:mm').format("YYYY-MM-DD HH:mm");
			if (stDate > enDate) {
				$(".evErrMsg").html('<span class="text-danger">Start Date can not be greated than end date.</span>');
				return false;
			} /*else if ((rec_until != "") && (stDate > rec_until)) {
				$(".evErrMsg").html('<span class="text-danger">Start Date can not be greated than until date.</span>');
				return false;
			}*/ else {
				$(".evErrMsg").html('');
				$.ajax({
					type: "POST",
					enctype: 'multipart/form-data',
					url: ajaxRootUrl,
					data: fd,
					processData: false,
					contentType: false,
					cache: false,
					timeout: 800000,
					dataType: "json",
					success: function (data) {
						// $("#output").text(data);
						console.log("SUCCESS : ", data);
						// $("#btnSubmit").prop("disabled", false);
						if (data.status == "success") {
							$("#actionEventModal input").val("");
							$("#actionEventModal #recurringCheck").prop("checked", false);
							$("#actionEventModal").modal("hide");
							// loadManualEvents(speakerId);
							// refresh_widget();

							var fValYMDst = new Date(stDate).toLocaleString("en-US", { timeZone: timeZoneCountry });
							var fValYMDed = (enDate != "") ? new Date(enDate).toLocaleString("en-US", { timeZone: timeZoneCountry }) : fValYMDst;

							// loadCalendar([]);
							calendar.removeAllEvents();
							//$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
							loadCalendar();
						}
					},
					error: function (e) {
						console.log("ERROR : ", e);
					}
				});
			}

		});

		$('.fieldDate').datetimepicker({
			timepicker: false,
			format: 'm-d-Y',
			timepickerScrollbar: false,
			scrollInput: false,
			scrollMonth: false
			//formatTime: "h:i a",
		});

		$(document).on('click', '.saveEventNote', function (e) {
			var event_note = $(this).closest("form").find(".event-note").val();
			if (event_note.trim() == "") {
				$(".msg_div").html('<span class="text-danger">Note field can not be empty.</span>');
				return false;
			}
			var module_id = $(this).data("moduleid");
			var module = $(this).data("module");
			console.log("module_id = ", module_id)
			console.log("module = ", module);
			var thisPointer = $(this);
			if (module == "CustomEvent" && module_id != "") {
				var fd = new FormData();
				fd.append('actfor', "savenote");
				fd.append('event_id', module_id);
				fd.append('notes', event_note);
				fd.append('speaker_id', speakerId);
				$.ajax({
					type: "POST",
					enctype: 'multipart/form-data',
					url: ajaxRootUrl,
					data: fd,
					processData: false,
					contentType: false,
					cache: false,
					timeout: 800000,
					dataType: "json",
					success: function (data) {
						// $("#output").text(data);
						console.log("SUCCESS : ", data);
						// $("#btnSubmit").prop("disabled", false);
						if (data.status == "success") {
							thisPointer.closest("form").find(".event-notes").html("");
							thisPointer.closest("form").find(".event-note").val("");
							load_manual_notes(module_id);
						}
					},
					error: function (e) {
						console.log("ERROR : ", e);
					}
				});



			} else if (module != "" && module_id != "") {
				var recordData = {
					"Parent_Id": module_id,
					"se_module": module,
					"Note_Content": event_note
				}
				ZOHO.CRM.API.insertRecord({ Entity: "Notes", APIData: recordData, Trigger: [] }).then(function (data) {
					if (data.data && data.data[0].code == "SUCCESS") {
						thisPointer.closest("form").find(".event-notes").html("");
						thisPointer.closest("form").find(".event-note").val("");
						load_event_notes(module_id, module);
					} else {
						console.log(data);
					}
				});
			}
		});

		// $("#date_months").datetimepicker({
		// 	format: 'F Y',
		// 	timepicker: false,
		// 	timepickerScrollbar: false,
		// 	scrollInput: false,
		// 	scrollMonth: false,
		// 	/*onClose: function (dateText, inst) {
		// 		$(this).datetimepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
		// 	}*/
		// });

		
		$("#date_months").datepicker({
			dateFormat: 'MM yy',
			changeMonth: true,
			changeYear: true,
			onClose: function (dateText, inst) {
				var selectedDate = inst.selectedYear+'-'+(inst.selectedMonth+1)+'-'+inst.selectedDay;
				var momentDate = moment(selectedDate, 'YYYY-M-D').format('YYYY-MM-DD');
				$(this).datepicker('option', 'defaultDate', new Date(inst.selectedYear, inst.selectedMonth, inst.selectedDay));
				$(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, inst.selectedDay));
				calendar.gotoDate( momentDate );
			}
		});
		

		load_all_authors();
		loadCalendar();
		//pull_speaker_opp_linking();

		function pull_speaker_opp_linking(skip = 0) {

			if( selectedStage == '' || selectedStage == 'all' ){
				var config = "getAllDealsWhereEventDateIsNotNull";
			}else if( selectedStage == "pending" ){
				var config = "getAllPendingDeals";
			}else if( selectedStage == "confirmed" ){
				var config = "getAllConfirmedDeals";
			}
			// if( localStorage.getItem(config+'_'+calInitialDate+'_allEvents') !== null ){
			// 	prepareRelatedOpportunities(JSON.parse(localStorage.getItem(config+'_'+calInitialDate+'_allEvents')));
			// }else{
				$.ajax({
					type: "POST",
					enctype: 'multipart/form-data',
					url: dataURL+config,
					data: {actfor: "nothing", selecteddate: calInitialDate, view: loadedView},
					cache: false,
					timeout: 800000,
					dataType: "json",
					success: function (data) {
						if (data) {
							//$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
							//$.LoadingOverlay("show");
							finalData = data;
							//localStorage.setItem(config+'_'+calInitialDate+'_allEvents', JSON.stringify(finalData) );
							prepareRelatedOpportunities(finalData);
						}else{
							$.LoadingOverlay("hide");
						}
					},
					error: function (e) {
						console.log("ERROR : ", e);
					}
				});
			// }
		}

		function prepareRelatedOpportunities(data) {
			console.log(data.length);
			if (data.length > 0) {
				var buildingEvents = $.map(data, function (item) {
					console.log(item);
					// if ((item.Status != "") && (item.Status != "null") && (item.Status != null) && (item.Hold_Date != "") && (item.Hold_End_Date != "")) {
					if ((item.Event_Date != "")) {
					
						//let itStatus = (item.Status != "") && (item.Status != "null") && (item.Status != null) ? item.Status + ' - ' : "";

						/*if( item.Stage == "Outreach" || item.Stage == "Conversation" ){
							var selectedClass = "dealOpen";
						}else */
						var icon = "❓";
						if( item.Stage == "Offer" || item.Stage == "Confirmation" ){
							var selectedClass = "dealOpen";//"dealPending";
						}else if( item.Stage == "Pre-Itinerary" || item.Stage == "Itinerary in Progress" || item.Stage == "Pre-Event" || item.Stage == "Post-Event" || item.Stage == "Event Complete" ){
							var selectedClass = "dealWon";
							if( item.Event_Medium == "Fly-to Event" ){
								var selectedClass = "flyToEvent";//"dealPending";
								icon = "✈️";
							}else if( item.Event_Medium == "Drive-to Event" ){
								var selectedClass = "driveToEvent";
								icon = "🚗";
							}else if( item.Event_Medium == "Virtual Visit" || item.Event_Medium == "Pre Recorded Stream" || item.Event_Medium == "Pre Recorded Stream w/Live Q&A" ){
								var selectedClass = "virtualVisit";
								icon = "💻";
							}
						}

						if( item.Stage != "Lost" && item.Stage != "Outreach" && item.Stage != "Conversation" ){


							return {
								id: item.id,
								type: "crm",
								itemInfo: item,
								content: "",
								title: (item.Event_Name == null)?icon+item.Deal_Name:icon+item.Event_Name,
								start: (item.Event_Date != "" && (item.Event_Date != null)) ? moment(item.Event_Date).format("YYYY-MM-DD HH:mm") : "",
								end: (item.Last_Day_of_Event != "" && (item.Last_Day_of_Event != null)) ? moment(item.Last_Day_of_Event).format("YYYY-MM-DD 23:00") : moment(item.Event_Date).format("YYYY-MM-DD 23:00"),
								//className: ["event", selectedClass],
								//color: 'red'
							};

						}
					}
				});
				
				//setTimeout(() => {
					// console.log(buildingEvents);
					loadEventInCalendar(buildingEvents);
					$.LoadingOverlay("hide");
				//}, 3000);
			}else{
				$.LoadingOverlay("hide");
			}
		}

		function loadEventInCalendar(calEvents = [], isRemove = "") {
			// removeEvents = calendar.getEventSources();
			// removeEvents.forEach(event => {
			// 	console.log("event: ", event)
			// 	// event.remove();
			// });
			// calendar.removeAllEvents();

			$.each(calEvents, function (key, item) {
				// calendar.removeEvents(item.id);
				// $('#speaker_calendar_main').fullCalendar('removeEvents', item.id);
				console.log(item);
				calendar.addEvent(item);
			});
			$.LoadingOverlay("hide");
		}

		function loadCalendar(calEvents = []) {

			calendar = new FullCalendar.Calendar(calendarEl, {
				initialView: 'listMonth',
				initialDate: calInitialDate,
				//aspectRatio: 2.7, //height of row
				selectable: true,
				events: calEvents,
				displayEventTime: false,
				allDaySlot: false,
				customButtons: {
			      myCustomButton: {
			        text: 'Refresh',
			        click: function() {
			          // Handle button click event
			          refresh_widget();
			        }
			      }
			    },
			    headerToolbar: {
			      //left: 'dayGridMonth,timeGridWeek,timeGridDay,listWeek',
			      //left: 'listMonth,listWeek,listYear,customListYear',
			      left: 'listMonth,listWeek,listYear',
			      //center: 'title',
			      //right: 'prev,next today myCustomButton' // Add the custom button to the header
			      right: 'today myCustomButton' // Add the custom button to the header
			    },
			    // views: {
			    //       customListYear: {
			    //         type: 'list',
			    //         duration: { months: 3 }, // Display 12 months
			    //         buttonText: 'List Year2',
			    //       },
			    //     },
			    buttonText: {
			        today: 'Today', // Custom text for the 'today' button
			        month: 'Month', // Custom text for the 'month' button
			        //week: 'Week',   // Custom text for the 'week' button
			        day: 'Day',     // Custom text for the 'day' button
			        //list: 'Week',   // Custom text for the 'list' button
			        listMonth: 'Month',   // Custom text for the 'list' button
			        listWeek: 'Week',   // Custom text for the 'list' button
			        listYear: 'Year'   // Custom text for the 'list' button
			        // Add any other custom button texts you want to change
			    },
			    viewClassNames: function(obj) {
			    	loadedView = obj.view.type;
			    	if(obj.view.type == "listMonth" || obj.view.type == "listYear"){
			    		var add_button = '<div class="fc-toolbar fc-toolbar-ltr custom-month-selector" style="margin-bottom:11px">\
			    			<div class="fc-toolbar-chunk">\
								<div class="fc-button-group">\
									<button type="button" title="Month Name" aria-pressed="false" class="fc-monthName-button fc-button fc-button-primary" data-month="01">Jan</button>\
									<button type="button" title="Month Name" aria-pressed="false" class="fc-monthName-button fc-button fc-button-primary" data-month="02">Feb</button>\
									<button type="button" title="Month Name" aria-pressed="false" class="fc-monthName-button fc-button fc-button-primary" data-month="03">Mar</button>\
									<button type="button" title="Month Name" aria-pressed="false" class="fc-monthName-button fc-button fc-button-primary" data-month="04">Apr</button>\
									<button type="button" title="Month Name" aria-pressed="false" class="fc-monthName-button fc-button fc-button-primary" data-month="05">May</button>\
									<button type="button" title="Month Name" aria-pressed="false" class="fc-monthName-button fc-button fc-button-primary" data-month="06">Jun</button>\
									<button type="button" title="Month Name" aria-pressed="false" class="fc-monthName-button fc-button fc-button-primary" data-month="07">Jul</button>\
									<button type="button" title="Month Name" aria-pressed="false" class="fc-monthName-button fc-button fc-button-primary" data-month="08">Aug</button>\
									<button type="button" title="Month Name" aria-pressed="false" class="fc-monthName-button fc-button fc-button-primary" data-month="09">Sep</button>\
									<button type="button" title="Month Name" aria-pressed="false" class="fc-monthName-button fc-button fc-button-primary" data-month="10">Oct</button>\
									<button type="button" title="Month Name" aria-pressed="false" class="fc-monthName-button fc-button fc-button-primary" data-month="11">Nov</button>\
									<button type="button" title="Month Name" aria-pressed="false" class="fc-monthName-button fc-button fc-button-primary" data-month="12">Dec</button>\
								</div>\
							</div>\
							<div class="fc-toolbar-chunk"></div>\
							<div class="fc-toolbar-chunk">\
								<select id="yearSelect" class="form-control"></select>\
							</div>\
						</div>';
						$(".custom-month-selector").remove(); 
			    		$(".fc-header-toolbar").after(add_button);
			    		var currentYear = new Date().getFullYear();
			    		var dateParts = calInitialDate.split('-');
			    		var startYear = 2000;
			    		var selectYear = $('#yearSelect');
			    		for (var year = currentYear+10; year >= startYear; year--) {
    		                var option = $('<option>', {
    		                    value: year,
    		                    text: year
    		                });
    		                if (year == dateParts[0]) {
	                            option.attr("selected", "selected");
	                        }
    		                selectYear.append(option);
    		            }

    		            // var currentDate = new Date();
    		            // var currentMonth = (currentDate.getMonth() + 1).toString().padStart(2, '0');
    		            
    		            var numericMonth = dateParts[1];

    		            var monthButtons = $('.fc-monthName-button');
    		            var initialSelectedMonth = $('.fc-monthName-button[data-month="'+numericMonth+'"]');
    		            initialSelectedMonth.addClass("fc-button-active");
    		            initialSelectedMonth.attr("aria-pressed",true);

    		            $('.fc-monthName-button').on('click', function () {
    		            	monthButtons.removeClass("fc-button-active");
    		            	monthButtons.attr("aria-pressed",false);
    		            	var selectedMonth = $(this);
    		            	selectedMonth.addClass("fc-button-active");
    		            	selectedMonth.attr("aria-pressed",true);
    		            	var formattedDate = $(this).data("month")+' '+$("#yearSelect").val();
    		            	const selectedDate = moment(formattedDate, 'MM YYYY').format("YYYY-MM-01");
    		            	calInitialDate = selectedDate;
    		            	calendar.gotoDate(selectedDate);
    		            });

    		            $(document).on('change', '#yearSelect', function () {
    		            	var selectedMonth = $('.fc-monthName-button[aria-pressed="true"]');
    		            	var formattedDate = $(selectedMonth).data("month")+' '+$("#yearSelect").val();
    		            	const selectedDate = moment(formattedDate, 'MM YYYY').format("YYYY-MM-01");
    		            	calendar.gotoDate(selectedDate);
    		            });
			    	}else{
			    		$("#date_months").datepicker("destroy");
			    		$("#date_months").datepicker({
			    			dateFormat: 'MM yy',
			    			changeMonth: true,
			    			changeYear: true,
			    			onClose: function (dateText, inst) {
			    				var selectedDate = inst.selectedYear+'-'+(inst.selectedMonth+1)+'-'+inst.selectedDay;
			    				var momentDate = moment(selectedDate, 'YYYY-M-D').format('YYYY-MM-DD');
			    				$(this).datepicker('option', 'defaultDate', new Date(inst.selectedYear, inst.selectedMonth, inst.selectedDay));
			    				$(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, inst.selectedDay));
			    				calendar.gotoDate( momentDate );
			    			}
			    		});
			    		calInitialDate = moment().format("YYYY-MM-DD");
			    		calendar.gotoDate(calInitialDate);
			    		$(".custom-month-selector").remove();
			    	}
			    },
			    eventDidMount: function(info) {
		          	// Add ribbon for one-day events
		          	if (info.event.end - info.event.start <= 24 * 60 * 60 * 1000) {
		          		var dotElement = info.el.querySelector('.fc-daygrid-event-dot');
		          		if( dotElement != null ){
		          			dotElement.style.display = 'none';
		          		}
		            	/*var titleElement = info.el.querySelector('.fc-event-title');
		            	titleElement.style.backgroundColor = 'yellow';*/
		          	}

		          	// Select the element containing the text
	        	  	var textContainer = $('.fc-listYear-view .fc-list-day .fc-list-day-text:first');

	        	  	// Get the text from the element
	        	  	var text = textContainer.text();

	        	  	// Split the text by the first space
	        	  	var parts = text.split(' ');

	        	  	// Take the first part (before the first space)
	        	  	var newText = parts[0];

	        	  	// Update the text in the element
	        	  	textContainer.text(newText);

	        	  	var isIncludeRow = true;

	        	  	$('.fc-listMonth-view table.fc-list-table tr, .fc-listWeek-view table.fc-list-table tr').each(function() {
	        	  	  var $row = $(this);

	        	  	  if ($row.hasClass('fc-list-day')) {
	        	  	    isIncludeRow = true; // Reset the flag for include rows after not-include row
	        	  	  } else {
	        	  	    $row.css('background-color', isIncludeRow ? 'white' : '#F1F1F1');
	        	  	    isIncludeRow = !isIncludeRow;
	        	  	  }
	        	  	});

	        	  	var isIncludeRowForYear = true;
	        	  	$('.fc-listYear-view table.fc-list-table tr').each(function() {
	        	  	  var $row = $(this);

	        	  	  if ($row.hasClass('fc-list-day')) {
	        	  	    //isIncludeRow = true; // Reset the flag for include rows after not-include row
	        	  	    return true;
	        	  	  } else {
	        	  	    $row.css('background-color', isIncludeRowForYear ? '#F1F1F1':'white');
	        	  	    isIncludeRowForYear = !isIncludeRowForYear;
	        	  	  }
	        	  	});
		        },
		        eventContent: function(info){
		        	// Select the element containing the text
	        	  	var textContainer = $('.fc-listYear-view .fc-list-day .fc-list-day-text:first');

	        	  	// Get the text from the element
	        	  	var text = textContainer.text();

	        	  	// Split the text by the first space
	        	  	var parts = text.split(' ');

	        	  	// Take the first part (before the first space)
	        	  	var newText = parts[0];

	        	  	// Update the text in the element
	        	  	textContainer.text(newText);

	        	  	//return {html: info.event.title};
		        },
				eventClick: function (info) {
					if (info.event.extendedProps.type == "crm") {
						console.log(info);
						$("#actionViewEventModal .event-title").html(info.event.title);
						$("#actionViewEventModal .event-deal").html('<a target="_blank" href="https://crm.zoho.com/crm/org812409302/tab/Deals/' + info.event.extendedProps.itemInfo.module_id + '">' + info.event.extendedProps.itemInfo.Deal_Name + '</a>');
						if( info.event.extendedProps.itemInfo.Confirmed_Author != null ){
							$("#actionViewEventModal .event-confirmed-author").html('<a target="_blank" href="https://crm.zoho.com/crm/org812409302/tab/CustomModule6/' + info.event.extendedProps.itemInfo.Confirmed_Author_ID + '">' + info.event.extendedProps.itemInfo.Confirmed_Author + '</a>');
						}
						$("#actionViewEventModal .suggested-authors").html("");

						$.ajax({
							type: 'POST',
							url: dataURL+"getAllSuggestedAuthorsOfTheDeal",
							data: {
								dealId: info.event.extendedProps.itemInfo.module_id
							},
							dataType: "json",
							success: function (data) {
								if (data) {
									finalData = data;
									//$(".deal_speaker").empty();
									//$(".deal_speaker").append('<option value="">-None-</option>');
									if (finalData.length > 0) {
										speakerId = finalData[0].Suggested_Authors_ID;
										jQuery.each(finalData, function (i, item) {
											let Shortlisted_Speaker = (item.Suggested_Authors) ? item.Suggested_Authors : "";
											let Shortlisted_Speaker_Id = (item.Suggested_Authors_ID) ? item.Suggested_Authors_ID : "";
											//$(".deal_speaker").append('<option value="' + Shortlisted_Speaker_Id + '">' + Shortlisted_Speaker + '</option>');
											$("#actionViewEventModal .suggested-authors").append('<li><a target="_blank" href="https://crm.zoho.com/crm/org812409302/tab/CustomModule6/' + Shortlisted_Speaker_Id + '">' + Shortlisted_Speaker + '</a></li>');
										});
									}
								}
							},
							error: function (error) {
								console.log(error);
							}
						});

						if( info.event.extendedProps.itemInfo.Account_Name != null ){
							$("#actionViewEventModal .event-account-name").html('<a target="_blank" href="https://crm.zoho.com/crm/org812409302/tab/Accounts/' + info.event.extendedProps.itemInfo.Account_Name_ID + '">' + info.event.extendedProps.itemInfo.Account_Name + '</a>');
						}
						$("#actionViewEventModal .event-date").html(moment(info.event.extendedProps.itemInfo.Event_Date).format("MM-DD-YYYY"));
						$("#actionViewEventModal .event-last-day").html(moment(info.event.extendedProps.itemInfo.Last_Day_of_Event).format("MM-DD-YYYY"));
						$("#actionViewEventModal .event-format").html(info.event.extendedProps.itemInfo.Event_Medium);
						$("#actionViewEventModal .au-agent").html(info.event.extendedProps.itemInfo.AU_Agent);
						$("#actionViewEventModal .event-designer").html(info.event.extendedProps.itemInfo.Event_Designer);
						$("#actionViewEventModal .event-city").html(info.event.extendedProps.itemInfo.Event_City);
						$("#actionViewEventModal .event-state").html(info.event.extendedProps.itemInfo.Event_State);
						$("#actionViewEventModal .saveEventNote").data("moduleid", info.event.extendedProps.itemInfo.module_id);
						$("#actionViewEventModal .saveEventNote").data("module", "Deals");
						$("#actionViewEventModal").data("moduleid", info.event.extendedProps.itemInfo.module_id);
						$("#actionViewEventModal").data("module", "Authors");
						$("#actionViewEventModal .event-notes").html("");
						load_event_notes(info.event.extendedProps.itemInfo.module_id, "Deals");
						$("#actionViewEventModal .eventDelete").hide();
						$("#actionViewEventModal .eventDeleteRecur").hide();
						$("#actionViewEventModal").modal("show");
					}else{
						$("#actionViewEventModalManual .event-title").html(info.event.extendedProps.modalEventName);
						$("#actionViewEventModalManual .edit-event-name-value").val(info.event.extendedProps.modalEventName);
						$.ajax({
							type: 'POST',
							url: dataURL+"getAuthorInfoById",
							data: {
								authorId: info.event.extendedProps.itemInfo.speaker_id
							},
							dataType: "json",
							success: function (data) {
								if (data) {
									$("#actionViewEventModalManual .event-link-author").html('<a target="_blank" href="https://crm.zoho.com/crm/org812409302/tab/CustomModule6/' + info.event.extendedProps.itemInfo.speaker_id + '">' + data.Name + '</a>');
						    		$("#actionViewEventModalManual .author-id-for-edit").val(info.event.extendedProps.itemInfo.speaker_id);
								}
							},
							error: function (error) {
								console.log(error);
							}
						});
						$("#actionViewEventModalManual .event-description-manual").html(info.event.extendedProps.itemInfo.description);
						$("#actionViewEventModalManual .ev-description-edit").val(info.event.extendedProps.itemInfo.description);
						$("#actionViewEventModalManual .saveEventNote").data("moduleid", info.event.id);
						$("#actionViewEventModalManual .saveEventNote").data("module", "CustomEvent");
						$("#actionViewEventModalManual").data("moduleid", info.event.id);
						$("#actionViewEventModalManual").data("module", "CustomEvent");
						$("#actionViewEventModalManual .event-date").html(moment(info.event.extendedProps.itemInfo.start).format("MM-DD-YYYY"));
						$("#actionViewEventModalManual .edit-start-date-value").val(moment(info.event.extendedProps.itemInfo.start).format("MM-DD-YYYY"));
						$("#actionViewEventModalManual .event-last-day").html(moment(info.event.extendedProps.itemInfo.end).format("MM-DD-YYYY"));
						$("#actionViewEventModalManual .edit-end-date-value").val(moment(info.event.extendedProps.itemInfo.end).format("MM-DD-YYYY"));
						$("#actionViewEventModalManual .event-notes").html('');
						$("#actionViewEventModalManual .event-id-for-edit").val(info.event.id);
						load_manual_notes(info.event.id);
						$("#actionViewEventModalManual .eventDelete").show();

						$("#actionViewEventModalManual .eventDeleteRecur").hide();

						$("#actionViewEventModalManual").modal("show");
					}
				},
				select: function (info, jsEvent, view) {
					$("#actionEventModal").find(".evStartDate").val(moment(info.start).format("MM-DD-YYYY"));
					$("#actionEventModal").find(".evEndDate").val(moment(info.start).format("MM-DD-YYYY"));
					/*if( speakerId == "" || speakerId == "all" ){
						$("#selectField").val('');
					}else{
						$("#selectField").val(speakerId);
					}*/
					$("#actionEventModal").modal("show");
				},
				datesSet: function (info) {
					buildMonthList();
				},

			});
			calendar.render();

			initializePlugin();
		}

		function load_manual_notes(event_id) {
			console.log("event_id "+ event_id);
			$.ajax({
				type: 'POST',
				url: ajaxRootUrl,
				data: {
					event_id: event_id,
					actfor: "getnotes",
				},
				dataType: "json",
				success: function (data) {
					if (data.status == "success") {
						finalData = data.data;
						$.each(finalData, function (key, item) {
							$("#actionViewEventModalManual .event-notes").append('<div class="note-wrapper"><div class="event-note-content event-note-content-original"><span class="main-note-content">' + item.notes + '</span>&nbsp;&nbsp;&nbsp;<span><i class="fa-solid fa-trash delete-note" data-noteid="'+item.id+'" style="cursor: pointer; font-size: 14px; color: #dc3545;"></i></span>&nbsp;&nbsp;&nbsp;<span><i class="fa-solid fa-pencil edit-note" style="cursor: pointer; font-size: 14px;"></i></span></div><div class="event-note-content-for-edit event-note-content" style="display:none; padding-top:13px;"><textarea class="form-control">' + item.notes + '</textarea>&nbsp;&nbsp;&nbsp;<span><i class="fa-solid fa-save edit-note-done" data-noteid="'+item.id+'" style="cursor: pointer; font-size: 14px;"></i></span></div></div>');
						});
					}
				},
				error: function (error) {
					console.log(error);
				}
			})
		}

		function load_event_notes(module_id, module, page = 1) {
			ZOHO.CRM.API.getRelatedRecords({ Entity: module, RecordID: module_id, RelatedList: "Notes", page: page, per_page: 200 })
				.then(function (response) {
					console.log(response)
					if (response.data) {
						finalData = response.data;
						console.log("Note Data");
						console.log(finalData);
						$.each(finalData, function (key, item) {
							$("#actionViewEventModal .event-notes").append('<div class="note-wrapper"><div class="event-note-content event-note-content-original"><span class="main-note-content">' + item.Note_Content + '</span>&nbsp;&nbsp;&nbsp;<span><i class="fa-solid fa-trash delete-crm-note" data-noteid="'+item.id+'" style="cursor: pointer; font-size: 14px; color: #dc3545;"></i></span>&nbsp;&nbsp;&nbsp;<span><i class="fa-solid fa-pencil edit-note" style="cursor: pointer; font-size: 14px;"></i></span></div><div class="event-note-content-for-edit event-note-content" style="display:none; padding-top:13px;"><textarea class="form-control">' + item.Note_Content + '</textarea>&nbsp;&nbsp;&nbsp;<span><i class="fa-solid fa-save edit-crm-note-done" data-noteid="'+item.id+'" style="cursor: pointer; font-size: 14px;"></i></span></div></div>');
							//$("#actionViewEventModal .event-notes").append('<div class="event-note-content">' + item.Note_Content + '</div>');
						});
					}
				})
		}

		function buildMonthList() {
			var month = calendar.getDate();
			console.log("month = ", month)
			$("#date_months").val(moment(month).format('MMMM YYYY'));
			calInitialDate = moment(month).format("YYYY-MM-DD");
			console.log("calInitialDate : ", calInitialDate);

			calendar.removeAllEvents();
			//$(".msg_div").html('<span class="text-success">Calendar data is loading...</span>');
			$.LoadingOverlay("show");
			if( selectedStage == '' || selectedStage == "all" ){
				//loadManualEvents();
				pull_speaker_opp_linking();
			}else if( selectedStage == 'pending' || selectedStage == 'confirmed' ){
				pull_speaker_opp_linking();
			}else if( selectedStage == 'custom' ){
				loadManualEvents();
			}
		}

		function refresh_widget() {
			//$(".msg_div").html('<span class="text-success">Refreshing...</span>');
			// cache.delete();
			// $('html[manifest=saveappoffline.appcache]').attr('content', '');
			//window.location.reload(true);
			loadCalendar();
		}

		function loadManualEvents() {
			$.ajax({
				type: 'POST',
				url: ajaxRootUrl,
				data: {
					selecteddate: calInitialDate,
					actfor: "get_all_events",
				},
				dataType: "json",
				success: function (data) {
					if (data.status == "success") {
						// $(".msg_div").html(data.message);
						// setTimeout(function(){
						// 	$(".msg_div").html("");
						// }, 2000);
						// $(".CustomEvent").closest(".fc-timegrid-event-harness").remove();
						// $(".CustomEvent").closest(".fc-daygrid-event-harness").remove();
						console.log("Manual data");
						console.log(data);
						prepareManualEvents(data.data);
					}
				},
				error: function (error) {
					console.log(error);
				}
			})
		}

		function fetch_speaker_details_by_id(speakerId) {

	    	return new Promise(resolve => {
		        $.ajax({
		        	type: 'POST',
		        	url: dataURL+"getAuthorInfoById",
		        	data: {
		        		authorId: speakerId
		        	},
		        	dataType: "json",
		        	success: async function (data) {
		        		//if (data.status == "success") {
		        			console.log('author_manual_event_data');
		        			console.log(data);
		        			resolve(data);
		        		//}
		        	},
		        	error: function (error) {
		        		console.log(error);
		        		resolve();
		        	}
		        });
		    });

		}

		async function prepareManualEvents(data) {
			// console.log(data.length);
			if (data.length > 0) {
				//$.LoadingOverlay("show");
				// console.log("data check");
				// console.log(data);
				var buildingEvents = [];
				await Promise.all($.map(data, async function (item) {
					// if((item.Status != "") && (item.Hold_Date != "") && (item.Hold_End_Date != "")){

					//const speakerDetails = await fetch_speaker_details_by_id(item.speaker_id);

					//console.log(speakerDetails);

					//if( speakerDetails.data !== undefined ){
						buildingEvents.push({
							id: item.id,
							type: "manual",
							itemInfo: item,
							title: item.Name + ' - ' +item.title,
							modalEventName: item.title,
							content: item.notes,
							start: (item.start != "" && (item.start != null)) ? moment(item.start).format("YYYY-MM-DD HH:mm") : "",
							end: (item.end != "" && (item.end != null)) ? moment(item.end).format("YYYY-MM-DD 23:00") : "",
							className: ["event", item.id + "_cEvent CustomEvent"],
							// textColor:"#000",
							// backgroundColor: '#fff'
						});
					//}
					// }
				}));

				console.log("prepareManualEvents");
				console.log(buildingEvents);

				setTimeout(() => {
					// console.log(buildingEvents);
					$.LoadingOverlay("hide");
					loadEventInCalendar(buildingEvents);
				}, 3000);
			}
		}
	})
	/*
	 * initialize the widget.
	 */
	ZOHO.embeddedApp.init();

};